/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.servicebindings;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v2.servicebindings.CreateServiceBindingRequest;
import org.cloudfoundry.client.v2.servicebindings.CreateServiceBindingResponse;
import org.cloudfoundry.client.v2.servicebindings.DeleteServiceBindingRequest;
import org.cloudfoundry.client.v2.servicebindings.DeleteServiceBindingResponse;
import org.cloudfoundry.client.v2.servicebindings.GetServiceBindingRequest;
import org.cloudfoundry.client.v2.servicebindings.GetServiceBindingResponse;
import org.cloudfoundry.client.v2.servicebindings.ListServiceBindingsRequest;
import org.cloudfoundry.client.v2.servicebindings.ListServiceBindingsResponse;
import org.cloudfoundry.client.v2.servicebindings.ServiceBindingsV2;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorServiceBindingsV2
extends AbstractClientV2Operations
implements ServiceBindingsV2 {
    public ReactorServiceBindingsV2(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<CreateServiceBindingResponse> create(CreateServiceBindingRequest request) {
        return this.post(request, CreateServiceBindingResponse.class, builder -> builder.pathSegment(new String[]{"v2", "service_bindings"}));
    }

    public Mono<DeleteServiceBindingResponse> delete(DeleteServiceBindingRequest request) {
        return this.delete(request, DeleteServiceBindingResponse.class, builder -> builder.pathSegment(new String[]{"v2", "service_bindings", request.getServiceBindingId()}));
    }

    public Mono<GetServiceBindingResponse> get(GetServiceBindingRequest request) {
        return this.get((Object)request, GetServiceBindingResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "service_bindings", request.getServiceBindingId()}));
    }

    public Mono<ListServiceBindingsResponse> list(ListServiceBindingsRequest request) {
        return this.get((Object)request, ListServiceBindingsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "service_bindings"}));
    }
}

