/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.serviceinstances;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v2.serviceinstances.BindServiceInstanceToRouteRequest;
import org.cloudfoundry.client.v2.serviceinstances.BindServiceInstanceToRouteResponse;
import org.cloudfoundry.client.v2.serviceinstances.CreateServiceInstanceRequest;
import org.cloudfoundry.client.v2.serviceinstances.CreateServiceInstanceResponse;
import org.cloudfoundry.client.v2.serviceinstances.DeleteServiceInstanceRequest;
import org.cloudfoundry.client.v2.serviceinstances.DeleteServiceInstanceResponse;
import org.cloudfoundry.client.v2.serviceinstances.GetServiceInstancePermissionsRequest;
import org.cloudfoundry.client.v2.serviceinstances.GetServiceInstancePermissionsResponse;
import org.cloudfoundry.client.v2.serviceinstances.GetServiceInstanceRequest;
import org.cloudfoundry.client.v2.serviceinstances.GetServiceInstanceResponse;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstanceServiceBindingsRequest;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstanceServiceBindingsResponse;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstanceServiceKeysRequest;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstanceServiceKeysResponse;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstancesRequest;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstancesResponse;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstances;
import org.cloudfoundry.client.v2.serviceinstances.UpdateServiceInstanceRequest;
import org.cloudfoundry.client.v2.serviceinstances.UpdateServiceInstanceResponse;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorServiceInstances
extends AbstractClientV2Operations
implements ServiceInstances {
    public ReactorServiceInstances(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<BindServiceInstanceToRouteResponse> bindToRoute(BindServiceInstanceToRouteRequest request) {
        return this.put(request, BindServiceInstanceToRouteResponse.class, builder -> builder.pathSegment(new String[]{"v2", "service_instances", request.getServiceInstanceId(), "routes", request.getRouteId()}));
    }

    public Mono<CreateServiceInstanceResponse> create(CreateServiceInstanceRequest request) {
        return this.post(request, CreateServiceInstanceResponse.class, builder -> builder.pathSegment(new String[]{"v2", "service_instances"}));
    }

    public Mono<DeleteServiceInstanceResponse> delete(DeleteServiceInstanceRequest request) {
        return this.delete(request, DeleteServiceInstanceResponse.class, builder -> builder.pathSegment(new String[]{"v2", "service_instances", request.getServiceInstanceId()}));
    }

    public Mono<GetServiceInstanceResponse> get(GetServiceInstanceRequest request) {
        return this.get((Object)request, GetServiceInstanceResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "service_instances", request.getServiceInstanceId()}));
    }

    public Mono<GetServiceInstancePermissionsResponse> getPermissions(GetServiceInstancePermissionsRequest request) {
        return this.get((Object)request, GetServiceInstancePermissionsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "service_instances", request.getServiceInstanceId(), "permissions"}));
    }

    public Mono<ListServiceInstancesResponse> list(ListServiceInstancesRequest request) {
        return this.get((Object)request, ListServiceInstancesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "service_instances"}));
    }

    public Mono<ListServiceInstanceServiceBindingsResponse> listServiceBindings(ListServiceInstanceServiceBindingsRequest request) {
        return this.get((Object)request, ListServiceInstanceServiceBindingsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "service_instances", request.getServiceInstanceId(), "service_bindings"}));
    }

    public Mono<ListServiceInstanceServiceKeysResponse> listServiceKeys(ListServiceInstanceServiceKeysRequest request) {
        return this.get((Object)request, ListServiceInstanceServiceKeysResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "service_instances", request.getServiceInstanceId(), "service_keys"}));
    }

    public Mono<UpdateServiceInstanceResponse> update(UpdateServiceInstanceRequest request) {
        return this.put(request, UpdateServiceInstanceResponse.class, builder -> builder.pathSegment(new String[]{"v2", "service_instances", request.getServiceInstanceId()}));
    }
}

