/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.servicekeys;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v2.servicekeys.CreateServiceKeyRequest;
import org.cloudfoundry.client.v2.servicekeys.CreateServiceKeyResponse;
import org.cloudfoundry.client.v2.servicekeys.DeleteServiceKeyRequest;
import org.cloudfoundry.client.v2.servicekeys.GetServiceKeyRequest;
import org.cloudfoundry.client.v2.servicekeys.GetServiceKeyResponse;
import org.cloudfoundry.client.v2.servicekeys.ListServiceKeysRequest;
import org.cloudfoundry.client.v2.servicekeys.ListServiceKeysResponse;
import org.cloudfoundry.client.v2.servicekeys.ServiceKeys;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorServiceKeys
extends AbstractClientV2Operations
implements ServiceKeys {
    public ReactorServiceKeys(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<CreateServiceKeyResponse> create(CreateServiceKeyRequest request) {
        return this.post(request, CreateServiceKeyResponse.class, builder -> builder.pathSegment(new String[]{"v2", "service_keys"}));
    }

    public Mono<Void> delete(DeleteServiceKeyRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "service_keys", request.getServiceKeyId()}));
    }

    public Mono<GetServiceKeyResponse> get(GetServiceKeyRequest request) {
        return this.get((Object)request, GetServiceKeyResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "service_keys", request.getServiceKeyId()}));
    }

    public Mono<ListServiceKeysResponse> list(ListServiceKeysRequest request) {
        return this.get((Object)request, ListServiceKeysResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "service_keys"}));
    }
}

