/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Function;
import org.cloudfoundry.reactor.client.CloudFoundryExceptionBuilder;
import org.cloudfoundry.reactor.client.QueryBuilder;
import org.cloudfoundry.reactor.client.v3.FilterBuilder;
import org.cloudfoundry.reactor.util.AbstractReactorOperations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.reactor.util.MultipartHttpClientRequest;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;
import reactor.io.netty.http.HttpClientRequest;
import reactor.io.netty.http.HttpClientResponse;
import reactor.io.netty.http.HttpException;

public abstract class AbstractClientV3Operations
extends AbstractReactorOperations {
    private final ObjectMapper objectMapper;

    protected AbstractClientV3Operations(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
        this.objectMapper = objectMapper;
    }

    protected final <T> Mono<T> delete(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doDelete(request, responseType, AbstractClientV3Operations.getUriAugmenter(request, uriTransformer), outbound -> outbound).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final <T> Mono<T> get(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGet(responseType, AbstractClientV3Operations.getUriAugmenter(request, uriTransformer), outbound -> outbound).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final Mono<HttpClientResponse> get(Object request, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGet(AbstractClientV3Operations.getUriAugmenter(request, uriTransformer), outbound -> outbound).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final <T> Mono<T> patch(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPatch(request, responseType, AbstractClientV3Operations.getUriAugmenter(request, uriTransformer), outbound -> outbound).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final <T> Mono<T> post(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPost(request, responseType, AbstractClientV3Operations.getUriAugmenter(request, uriTransformer), outbound -> outbound).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final <T> Mono<T> post(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<MultipartHttpClientRequest, Mono<Void>> requestTransformer) {
        return this.doPost(responseType, AbstractClientV3Operations.getUriAugmenter(request, uriTransformer), outbound -> (Mono)requestTransformer.apply(new MultipartHttpClientRequest(this.objectMapper, (HttpClientRequest)outbound))).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final <T> Mono<T> put(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPut(request, responseType, AbstractClientV3Operations.getUriAugmenter(request, uriTransformer), outbound -> outbound).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    private static Function<UriComponentsBuilder, UriComponentsBuilder> getUriAugmenter(Object request, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return builder -> {
            FilterBuilder.augment(builder, request);
            QueryBuilder.augment(builder, request);
            return (UriComponentsBuilder)uriTransformer.apply((UriComponentsBuilder)builder);
        };
    }
}

