/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.cloudfoundry.client.v3.FilterParameter;
import org.cloudfoundry.reactor.client.MethodNameComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

final class FilterBuilder {
    private FilterBuilder() {
    }

    public static void augment(UriComponentsBuilder builder, Object instance) {
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(instance.getClass());
        Arrays.sort(methods, MethodNameComparator.INSTANCE);
        for (Method method : methods) {
            String value;
            FilterParameter filterParameter = (FilterParameter)AnnotationUtils.getAnnotation((Method)method, FilterParameter.class);
            if (filterParameter == null || !StringUtils.hasText((String)(value = FilterBuilder.getValue(method, instance)))) continue;
            builder.queryParam(filterParameter.value(), new Object[]{value});
        }
    }

    private static String getValue(Method method, Object instance) {
        ReflectionUtils.makeAccessible((Method)method);
        Object value = ReflectionUtils.invokeMethod((Method)method, (Object)instance);
        if (value == null) {
            return "";
        }
        if (value instanceof Collection) {
            List collection = ((Collection)value).stream().filter(o -> !ObjectUtils.isEmpty((Object)o)).collect(Collectors.toList());
            return StringUtils.collectionToCommaDelimitedString(collection);
        }
        return value.toString();
    }
}

