/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.applications;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v3.applications.ApplicationsV3;
import org.cloudfoundry.client.v3.applications.AssignApplicationDropletRequest;
import org.cloudfoundry.client.v3.applications.AssignApplicationDropletResponse;
import org.cloudfoundry.client.v3.applications.CancelApplicationTaskRequest;
import org.cloudfoundry.client.v3.applications.CancelApplicationTaskResponse;
import org.cloudfoundry.client.v3.applications.CreateApplicationRequest;
import org.cloudfoundry.client.v3.applications.CreateApplicationResponse;
import org.cloudfoundry.client.v3.applications.DeleteApplicationRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationEnvironmentRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationEnvironmentResponse;
import org.cloudfoundry.client.v3.applications.GetApplicationProcessRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationProcessResponse;
import org.cloudfoundry.client.v3.applications.GetApplicationProcessStatisticsRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationProcessStatisticsResponse;
import org.cloudfoundry.client.v3.applications.GetApplicationRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationResponse;
import org.cloudfoundry.client.v3.applications.GetApplicationTaskRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationTaskResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationDropletsRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationDropletsResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationPackagesRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationPackagesResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationProcessesRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationProcessesResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationTasksRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationTasksResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationsRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationsResponse;
import org.cloudfoundry.client.v3.applications.ScaleApplicationRequest;
import org.cloudfoundry.client.v3.applications.ScaleApplicationResponse;
import org.cloudfoundry.client.v3.applications.StartApplicationRequest;
import org.cloudfoundry.client.v3.applications.StartApplicationResponse;
import org.cloudfoundry.client.v3.applications.StopApplicationRequest;
import org.cloudfoundry.client.v3.applications.StopApplicationResponse;
import org.cloudfoundry.client.v3.applications.TerminateApplicationInstanceRequest;
import org.cloudfoundry.client.v3.applications.UpdateApplicationRequest;
import org.cloudfoundry.client.v3.applications.UpdateApplicationResponse;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorApplicationsV3
extends AbstractClientV3Operations
implements ApplicationsV3 {
    public ReactorApplicationsV3(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<AssignApplicationDropletResponse> assignDroplet(AssignApplicationDropletRequest request) {
        return this.put(request, AssignApplicationDropletResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "current_droplet"}));
    }

    public Mono<CancelApplicationTaskResponse> cancelTask(CancelApplicationTaskRequest request) {
        return this.put(request, CancelApplicationTaskResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "tasks", request.getTaskId(), "cancel"}));
    }

    public Mono<CreateApplicationResponse> create(CreateApplicationRequest request) {
        return this.post(request, CreateApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps"}));
    }

    public Mono<Void> delete(DeleteApplicationRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId()}));
    }

    public Mono<GetApplicationResponse> get(GetApplicationRequest request) {
        return this.get(request, GetApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId()}));
    }

    public Mono<GetApplicationEnvironmentResponse> getEnvironment(GetApplicationEnvironmentRequest request) {
        return this.get(request, GetApplicationEnvironmentResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "env"}));
    }

    public Mono<GetApplicationProcessResponse> getProcess(GetApplicationProcessRequest request) {
        return this.get(request, GetApplicationProcessResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "processes", request.getType()}));
    }

    public Mono<GetApplicationProcessStatisticsResponse> getProcessStatistics(GetApplicationProcessStatisticsRequest request) {
        return this.get(request, GetApplicationProcessStatisticsResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "processes", request.getType(), "stats"}));
    }

    public Mono<GetApplicationTaskResponse> getTask(GetApplicationTaskRequest request) {
        return this.get(request, GetApplicationTaskResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "tasks", request.getTaskId()}));
    }

    public Mono<ListApplicationsResponse> list(ListApplicationsRequest request) {
        return this.get(request, ListApplicationsResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps"}));
    }

    public Mono<ListApplicationDropletsResponse> listDroplets(ListApplicationDropletsRequest request) {
        return this.get(request, ListApplicationDropletsResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "droplets"}));
    }

    public Mono<ListApplicationPackagesResponse> listPackages(ListApplicationPackagesRequest request) {
        return this.get(request, ListApplicationPackagesResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "packages"}));
    }

    public Mono<ListApplicationProcessesResponse> listProcesses(ListApplicationProcessesRequest request) {
        return this.get(request, ListApplicationProcessesResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "processes"}));
    }

    public Mono<ListApplicationTasksResponse> listTasks(ListApplicationTasksRequest request) {
        return this.get(request, ListApplicationTasksResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "tasks"}));
    }

    public Mono<ScaleApplicationResponse> scale(ScaleApplicationRequest request) {
        return this.put(request, ScaleApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "processes", request.getType(), "scale"}));
    }

    public Mono<StartApplicationResponse> start(StartApplicationRequest request) {
        return this.put(request, StartApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "start"}));
    }

    public Mono<StopApplicationResponse> stop(StopApplicationRequest request) {
        return this.put(request, StopApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "stop"}));
    }

    public Mono<Void> terminateInstance(TerminateApplicationInstanceRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "processes", request.getType(), "instances", request.getIndex()}));
    }

    public Mono<UpdateApplicationResponse> update(UpdateApplicationRequest request) {
        return this.patch(request, UpdateApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId()}));
    }
}

