/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.packages;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v3.packages.CopyPackageRequest;
import org.cloudfoundry.client.v3.packages.CopyPackageResponse;
import org.cloudfoundry.client.v3.packages.CreatePackageRequest;
import org.cloudfoundry.client.v3.packages.CreatePackageResponse;
import org.cloudfoundry.client.v3.packages.DeletePackageRequest;
import org.cloudfoundry.client.v3.packages.DownloadPackageRequest;
import org.cloudfoundry.client.v3.packages.GetPackageRequest;
import org.cloudfoundry.client.v3.packages.GetPackageResponse;
import org.cloudfoundry.client.v3.packages.ListPackagesRequest;
import org.cloudfoundry.client.v3.packages.ListPackagesResponse;
import org.cloudfoundry.client.v3.packages.Packages;
import org.cloudfoundry.client.v3.packages.StagePackageRequest;
import org.cloudfoundry.client.v3.packages.StagePackageResponse;
import org.cloudfoundry.client.v3.packages.UploadPackageRequest;
import org.cloudfoundry.client.v3.packages.UploadPackageResponse;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.io.netty.common.NettyInbound;
import reactor.io.netty.http.HttpClient;

public final class ReactorPackages
extends AbstractClientV3Operations
implements Packages {
    public ReactorPackages(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<CopyPackageResponse> copy(CopyPackageRequest request) {
        return this.post(request, CopyPackageResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "packages"}));
    }

    public Mono<CreatePackageResponse> create(CreatePackageRequest request) {
        return this.post(request, CreatePackageResponse.class, builder -> builder.pathSegment(new String[]{"v3", "apps", request.getApplicationId(), "packages"}));
    }

    public Mono<Void> delete(DeletePackageRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v3", "packages", request.getPackageId()}));
    }

    public Flux<byte[]> download(DownloadPackageRequest request) {
        return this.get(request, builder -> builder.pathSegment(new String[]{"v3", "packages", request.getPackageId(), "download"})).flatMap(NettyInbound::receiveByteArray);
    }

    public Mono<GetPackageResponse> get(GetPackageRequest request) {
        return this.get(request, GetPackageResponse.class, builder -> builder.pathSegment(new String[]{"v3", "packages", request.getPackageId()}));
    }

    public Mono<ListPackagesResponse> list(ListPackagesRequest request) {
        return this.get(request, ListPackagesResponse.class, builder -> builder.pathSegment(new String[]{"v3", "packages"}));
    }

    public Mono<StagePackageResponse> stage(StagePackageRequest request) {
        return this.post(request, StagePackageResponse.class, builder -> builder.pathSegment(new String[]{"v3", "packages", request.getPackageId(), "droplets"}));
    }

    public Mono<UploadPackageResponse> upload(UploadPackageRequest request) {
        return this.post(request, UploadPackageResponse.class, builder -> builder.pathSegment(new String[]{"v3", "packages", request.getPackageId(), "upload"}), outbound -> outbound.addPart(part -> part.setContentDispositionFormData("bits", "application.zip").addHeader((CharSequence)CONTENT_TYPE, (CharSequence)APPLICATION_ZIP).sendInputStream(request.getBits())).done());
    }
}

