/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.processes;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v3.processes.GetProcessRequest;
import org.cloudfoundry.client.v3.processes.GetProcessResponse;
import org.cloudfoundry.client.v3.processes.GetProcessStatisticsRequest;
import org.cloudfoundry.client.v3.processes.GetProcessStatisticsResponse;
import org.cloudfoundry.client.v3.processes.ListProcessesRequest;
import org.cloudfoundry.client.v3.processes.ListProcessesResponse;
import org.cloudfoundry.client.v3.processes.Processes;
import org.cloudfoundry.client.v3.processes.ScaleProcessRequest;
import org.cloudfoundry.client.v3.processes.ScaleProcessResponse;
import org.cloudfoundry.client.v3.processes.TerminateProcessInstanceRequest;
import org.cloudfoundry.client.v3.processes.UpdateProcessRequest;
import org.cloudfoundry.client.v3.processes.UpdateProcessResponse;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorProcesses
extends AbstractClientV3Operations
implements Processes {
    public ReactorProcesses(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<GetProcessResponse> get(GetProcessRequest request) {
        return this.get(request, GetProcessResponse.class, builder -> builder.pathSegment(new String[]{"v3", "processes", request.getProcessId()}));
    }

    public Mono<GetProcessStatisticsResponse> getStatistics(GetProcessStatisticsRequest request) {
        return this.get(request, GetProcessStatisticsResponse.class, builder -> builder.pathSegment(new String[]{"v3", "processes", request.getProcessId(), "stats"}));
    }

    public Mono<ListProcessesResponse> list(ListProcessesRequest request) {
        return this.get(request, ListProcessesResponse.class, builder -> builder.pathSegment(new String[]{"v3", "processes"}));
    }

    public Mono<ScaleProcessResponse> scale(ScaleProcessRequest request) {
        return this.put(request, ScaleProcessResponse.class, builder -> builder.pathSegment(new String[]{"v3", "processes", request.getProcessId(), "scale"}));
    }

    public Mono<Void> terminateInstance(TerminateProcessInstanceRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v3", "processes", request.getProcessId(), "instances", request.getIndex()}));
    }

    public Mono<UpdateProcessResponse> update(UpdateProcessRequest request) {
        return this.patch(request, UpdateProcessResponse.class, builder -> builder.pathSegment(new String[]{"v3", "processes", request.getProcessId()}));
    }
}

