/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.doppler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.cloudfoundry.doppler.ContainerMetric;
import org.cloudfoundry.doppler.ContainerMetricsRequest;
import org.cloudfoundry.doppler.CounterEvent;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.doppler.Error;
import org.cloudfoundry.doppler.Event;
import org.cloudfoundry.doppler.FirehoseRequest;
import org.cloudfoundry.doppler.HttpStart;
import org.cloudfoundry.doppler.HttpStop;
import org.cloudfoundry.doppler.LogMessage;
import org.cloudfoundry.doppler.RecentLogsRequest;
import org.cloudfoundry.doppler.StreamRequest;
import org.cloudfoundry.dropsonde.events.Envelope;
import org.cloudfoundry.dropsonde.events.HttpStartStop;
import org.cloudfoundry.dropsonde.events.ValueMetric;
import org.cloudfoundry.reactor.doppler.AbstractDopplerOperations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.reactor.util.ConnectionContextSupplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.util.Exceptions;
import reactor.io.netty.common.NettyInbound;
import reactor.io.netty.http.HttpClient;

public final class ReactorDopplerClient
extends AbstractDopplerOperations
implements DopplerClient {
    ReactorDopplerClient(ConnectionContextSupplier cloudFoundryClient) {
        this(cloudFoundryClient.getConnectionContext().getAuthorizationProvider(), cloudFoundryClient.getConnectionContext().getHttpClient(), cloudFoundryClient.getConnectionContext().getObjectMapper(), cloudFoundryClient.getConnectionContext().getRoot("doppler_logging_endpoint"));
    }

    ReactorDopplerClient(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Flux<ContainerMetric> containerMetrics(ContainerMetricsRequest request) {
        return this.get(builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "containermetrics"})).flatMap(inbound -> inbound.receiveMultipart().receiveInputStream()).map(ReactorDopplerClient::toEnvelope).map(ReactorDopplerClient::toEvent);
    }

    public Flux<Event> firehose(FirehoseRequest request) {
        return this.ws(builder -> builder.pathSegment(new String[]{"firehose", request.getSubscriptionId()})).flatMap(NettyInbound::receiveInputStream).map(ReactorDopplerClient::toEnvelope).map(ReactorDopplerClient::toEvent);
    }

    public Flux<LogMessage> recentLogs(RecentLogsRequest request) {
        return this.get(builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "recentlogs"})).flatMap(inbound -> inbound.receiveMultipart().receiveInputStream()).map(ReactorDopplerClient::toEnvelope).map(ReactorDopplerClient::toEvent);
    }

    public Flux<Event> stream(StreamRequest request) {
        return this.ws(builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "stream"})).flatMap(NettyInbound::receiveInputStream).map(ReactorDopplerClient::toEnvelope).map(ReactorDopplerClient::toEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Envelope toEnvelope(InputStream inputStream) {
        try (InputStream in = inputStream;){
            Envelope envelope = (Envelope)Envelope.ADAPTER.decode(in);
            return envelope;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static <T extends Event> T toEvent(Envelope envelope) {
        switch (envelope.eventType) {
            case HttpStart: {
                return (T)HttpStart.from((org.cloudfoundry.dropsonde.events.HttpStart)envelope.httpStart);
            }
            case HttpStop: {
                return (T)HttpStop.from((org.cloudfoundry.dropsonde.events.HttpStop)envelope.httpStop);
            }
            case HttpStartStop: {
                return (T)org.cloudfoundry.doppler.HttpStartStop.from((HttpStartStop)envelope.httpStartStop);
            }
            case LogMessage: {
                return (T)LogMessage.from((org.cloudfoundry.dropsonde.events.LogMessage)envelope.logMessage);
            }
            case ValueMetric: {
                return (T)org.cloudfoundry.doppler.ValueMetric.from((ValueMetric)envelope.valueMetric);
            }
            case CounterEvent: {
                return (T)CounterEvent.from((org.cloudfoundry.dropsonde.events.CounterEvent)envelope.counterEvent);
            }
            case Error: {
                return (T)Error.from((org.cloudfoundry.dropsonde.events.Error)envelope.error);
            }
            case ContainerMetric: {
                return (T)ContainerMetric.from((org.cloudfoundry.dropsonde.events.ContainerMetric)envelope.containerMetric);
            }
        }
        throw new IllegalStateException(String.format("Envelope event type %s is unsupported", envelope.eventType));
    }

    public static ReactorDopplerClientBuilder builder() {
        return new ReactorDopplerClientBuilder();
    }

    public static class ReactorDopplerClientBuilder {
        private ConnectionContextSupplier cloudFoundryClient;

        ReactorDopplerClientBuilder() {
        }

        public ReactorDopplerClientBuilder cloudFoundryClient(ConnectionContextSupplier cloudFoundryClient) {
            this.cloudFoundryClient = cloudFoundryClient;
            return this;
        }

        public ReactorDopplerClient build() {
            return new ReactorDopplerClient(this.cloudFoundryClient);
        }

        public String toString() {
            return "ReactorDopplerClient.ReactorDopplerClientBuilder(cloudFoundryClient=" + this.cloudFoundryClient + ")";
        }
    }
}

