/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Function;
import org.cloudfoundry.reactor.client.QueryBuilder;
import org.cloudfoundry.reactor.uaa.BasicAuthorizationBuilder;
import org.cloudfoundry.reactor.uaa.IdentityZoneBuilder;
import org.cloudfoundry.reactor.uaa.VersionBuilder;
import org.cloudfoundry.reactor.util.AbstractReactorOperations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;
import reactor.io.netty.http.HttpClientRequest;
import reactor.io.netty.http.HttpClientResponse;

public abstract class AbstractUaaOperations
extends AbstractReactorOperations {
    protected AbstractUaaOperations(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    protected static Function<UriComponentsBuilder, UriComponentsBuilder> getUriAugmenter(Object request, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return builder -> {
            QueryBuilder.augment(builder, request);
            return (UriComponentsBuilder)uriTransformer.apply((UriComponentsBuilder)builder);
        };
    }

    protected final <T> Mono<T> delete(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doDelete(request, responseType, AbstractUaaOperations.getUriAugmenter(request, uriTransformer), AbstractUaaOperations.getRequestTransformer(request));
    }

    protected final <T> Mono<T> delete(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.doDelete(request, responseType, AbstractUaaOperations.getUriAugmenter(request, uriTransformer), outbound -> {
            AbstractUaaOperations.getRequestTransformer(request).apply((HttpClientRequest)outbound);
            return (HttpClientRequest)requestTransformer.apply((HttpClientRequest)outbound);
        });
    }

    protected final Mono<HttpClientResponse> get(Object request, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGet(AbstractUaaOperations.getUriAugmenter(request, uriTransformer), AbstractUaaOperations.getRequestTransformer(request));
    }

    protected final <T> Mono<T> get(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGet(responseType, AbstractUaaOperations.getUriAugmenter(request, uriTransformer), AbstractUaaOperations.getRequestTransformer(request));
    }

    protected final <T> Mono<T> get(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.doGet(responseType, AbstractUaaOperations.getUriAugmenter(request, uriTransformer), outbound -> {
            AbstractUaaOperations.getRequestTransformer(request).apply((HttpClientRequest)outbound);
            return (HttpClientRequest)requestTransformer.apply((HttpClientRequest)outbound);
        });
    }

    protected final Mono<HttpClientResponse> getNoAuth(Object request, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGetNoAuth(AbstractUaaOperations.getUriAugmenter(request, uriTransformer), AbstractUaaOperations.getRequestTransformer(request));
    }

    protected final <T> Mono<T> post(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.doPost(request, responseType, AbstractUaaOperations.getUriAugmenter(request, uriTransformer), outbound -> {
            AbstractUaaOperations.getRequestTransformer(request).apply((HttpClientRequest)outbound);
            return (HttpClientRequest)requestTransformer.apply((HttpClientRequest)outbound);
        });
    }

    protected final <T> Mono<T> post(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPost(request, responseType, AbstractUaaOperations.getUriAugmenter(request, uriTransformer), AbstractUaaOperations.getRequestTransformer(request));
    }

    protected final <T> Mono<T> postForm(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.postForm(request, responseType, uriTransformer, outbound -> outbound);
    }

    protected final <T> Mono<T> postForm(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.doPost(responseType, AbstractUaaOperations.getUriAugmenter(request, uriTransformer), outbound -> {
            outbound.headers().remove((CharSequence)AUTHORIZATION);
            AbstractUaaOperations.getRequestTransformer(request).apply((HttpClientRequest)outbound);
            return ((HttpClientRequest)requestTransformer.apply((HttpClientRequest)outbound)).addHeader((CharSequence)CONTENT_TYPE, (CharSequence)APPLICATION_X_WWW_FORM_URLENCODED).removeTransferEncodingChunked().sendHeaders();
        });
    }

    protected final <T> Mono<T> put(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPut(request, responseType, AbstractUaaOperations.getUriAugmenter(request, uriTransformer), AbstractUaaOperations.getRequestTransformer(request));
    }

    private static Function<HttpClientRequest, HttpClientRequest> getRequestTransformer(Object request) {
        return outbound -> {
            BasicAuthorizationBuilder.augment(outbound, request);
            IdentityZoneBuilder.augment(outbound, request);
            VersionBuilder.augment(outbound, request);
            return outbound;
        };
    }
}

