/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.reactor.uaa.authorizations.ReactorAuthorizations;
import org.cloudfoundry.reactor.uaa.groups.ReactorGroups;
import org.cloudfoundry.reactor.uaa.identityproviders.ReactorIdentityProviders;
import org.cloudfoundry.reactor.uaa.identityzones.ReactorIdentityZones;
import org.cloudfoundry.reactor.uaa.tokens.ReactorTokens;
import org.cloudfoundry.reactor.uaa.users.ReactorUsers;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.reactor.util.ConnectionContextSupplier;
import org.cloudfoundry.uaa.UaaClient;
import org.cloudfoundry.uaa.authorizations.Authorizations;
import org.cloudfoundry.uaa.groups.Groups;
import org.cloudfoundry.uaa.identityproviders.IdentityProviders;
import org.cloudfoundry.uaa.identityzones.IdentityZones;
import org.cloudfoundry.uaa.tokens.Tokens;
import org.cloudfoundry.uaa.users.Users;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorUaaClient
implements UaaClient {
    private final Authorizations authorizations;
    private final Groups groups;
    private final IdentityProviders identityProviders;
    private final IdentityZones identityZones;
    private final Tokens tokens;
    private final Users users;

    ReactorUaaClient(ConnectionContextSupplier cloudFoundryClient) {
        this(cloudFoundryClient.getConnectionContext().getAuthorizationProvider(), cloudFoundryClient.getConnectionContext().getHttpClient(), cloudFoundryClient.getConnectionContext().getObjectMapper(), cloudFoundryClient.getConnectionContext().getRoot("token_endpoint"));
    }

    ReactorUaaClient(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        this.authorizations = new ReactorAuthorizations(authorizationProvider, httpClient, objectMapper, root);
        this.groups = new ReactorGroups(authorizationProvider, httpClient, objectMapper, root);
        this.identityProviders = new ReactorIdentityProviders(authorizationProvider, httpClient, objectMapper, root);
        this.identityZones = new ReactorIdentityZones(authorizationProvider, httpClient, objectMapper, root);
        this.tokens = new ReactorTokens(authorizationProvider, httpClient, objectMapper, root);
        this.users = new ReactorUsers(authorizationProvider, httpClient, objectMapper, root);
    }

    public Authorizations authorizations() {
        return this.authorizations;
    }

    public Groups groups() {
        return this.groups;
    }

    public IdentityProviders identityProviders() {
        return this.identityProviders;
    }

    public IdentityZones identityZones() {
        return this.identityZones;
    }

    public Tokens tokens() {
        return this.tokens;
    }

    public Users users() {
        return this.users;
    }

    public static ReactorUaaClientBuilder builder() {
        return new ReactorUaaClientBuilder();
    }

    public static class ReactorUaaClientBuilder {
        private ConnectionContextSupplier cloudFoundryClient;

        ReactorUaaClientBuilder() {
        }

        public ReactorUaaClientBuilder cloudFoundryClient(ConnectionContextSupplier cloudFoundryClient) {
            this.cloudFoundryClient = cloudFoundryClient;
            return this;
        }

        public ReactorUaaClient build() {
            return new ReactorUaaClient(this.cloudFoundryClient);
        }

        public String toString() {
            return "ReactorUaaClient.ReactorUaaClientBuilder(cloudFoundryClient=" + this.cloudFoundryClient + ")";
        }
    }
}

