/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa.authorizations;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.util.AsciiString;
import java.util.Optional;
import org.cloudfoundry.reactor.uaa.AbstractUaaOperations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.uaa.ResponseType;
import org.cloudfoundry.uaa.authorizations.Authorizations;
import org.cloudfoundry.uaa.authorizations.AuthorizeByAuthorizationCodeGrantApiRequest;
import org.cloudfoundry.uaa.authorizations.AuthorizeByAuthorizationCodeGrantBrowserRequest;
import org.cloudfoundry.uaa.authorizations.AuthorizeByImplicitGrantBrowserRequest;
import org.cloudfoundry.uaa.authorizations.AuthorizeByOpenIdWithAuthorizationCodeGrantRequest;
import org.cloudfoundry.uaa.authorizations.AuthorizeByOpenIdWithIdTokenRequest;
import org.cloudfoundry.uaa.authorizations.AuthorizeByOpenIdWithImplicitGrantRequest;
import org.cloudfoundry.util.ExceptionUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorAuthorizations
extends AbstractUaaOperations
implements Authorizations {
    private static final AsciiString LOCATION = new AsciiString((CharSequence)"Location");

    public ReactorAuthorizations(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<String> authorizationCodeGrantApi(AuthorizeByAuthorizationCodeGrantApiRequest request) {
        return this.get(request, builder -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.CODE})).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION)).then(location -> ReactorAuthorizations.uriParameterValue(location, "code"));
    }

    public Mono<String> authorizationCodeGrantBrowser(AuthorizeByAuthorizationCodeGrantBrowserRequest request) {
        return this.getNoAuth(request, builder -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.CODE})).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION));
    }

    public Mono<String> implicitGrantBrowser(AuthorizeByImplicitGrantBrowserRequest request) {
        return this.getNoAuth(request, builder -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.TOKEN})).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION));
    }

    public Mono<String> openIdWithAuthorizationCodeGrant(AuthorizeByOpenIdWithAuthorizationCodeGrantRequest request) {
        return this.getNoAuth(request, builder -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.ID_TOKEN_CODE})).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION));
    }

    public Mono<String> openIdWithIdToken(AuthorizeByOpenIdWithIdTokenRequest request) {
        return this.get(request, builder -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.ID_TOKEN})).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION));
    }

    public Mono<String> openIdWithImplicitGrant(AuthorizeByOpenIdWithImplicitGrantRequest request) {
        return this.get(request, builder -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.ID_TOKEN_TOKEN})).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION));
    }

    private static Mono<String> uriParameterValue(String uriString, String parameter) {
        return Optional.ofNullable(UriComponentsBuilder.fromUriString((String)uriString).build().getQueryParams().getFirst((Object)parameter)).map(Mono::just).orElse(ExceptionUtils.illegalState((String)String.format("Parameter %s not in URI %s", parameter, uriString), (Object[])new Object[0]));
    }
}

