/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa.groups;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.reactor.uaa.AbstractUaaOperations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.uaa.groups.AddMemberRequest;
import org.cloudfoundry.uaa.groups.AddMemberResponse;
import org.cloudfoundry.uaa.groups.CheckMembershipRequest;
import org.cloudfoundry.uaa.groups.CheckMembershipResponse;
import org.cloudfoundry.uaa.groups.CreateGroupRequest;
import org.cloudfoundry.uaa.groups.CreateGroupResponse;
import org.cloudfoundry.uaa.groups.DeleteGroupRequest;
import org.cloudfoundry.uaa.groups.DeleteGroupResponse;
import org.cloudfoundry.uaa.groups.GetGroupRequest;
import org.cloudfoundry.uaa.groups.GetGroupResponse;
import org.cloudfoundry.uaa.groups.Groups;
import org.cloudfoundry.uaa.groups.ListExternalGroupMappingsRequest;
import org.cloudfoundry.uaa.groups.ListExternalGroupMappingsResponse;
import org.cloudfoundry.uaa.groups.ListGroupsRequest;
import org.cloudfoundry.uaa.groups.ListGroupsResponse;
import org.cloudfoundry.uaa.groups.ListMembersRequest;
import org.cloudfoundry.uaa.groups.ListMembersResponse;
import org.cloudfoundry.uaa.groups.MapExternalGroupRequest;
import org.cloudfoundry.uaa.groups.MapExternalGroupResponse;
import org.cloudfoundry.uaa.groups.RemoveMemberRequest;
import org.cloudfoundry.uaa.groups.RemoveMemberResponse;
import org.cloudfoundry.uaa.groups.UnmapExternalGroupByGroupDisplayNameRequest;
import org.cloudfoundry.uaa.groups.UnmapExternalGroupByGroupDisplayNameResponse;
import org.cloudfoundry.uaa.groups.UnmapExternalGroupByGroupIdRequest;
import org.cloudfoundry.uaa.groups.UnmapExternalGroupByGroupIdResponse;
import org.cloudfoundry.uaa.groups.UpdateGroupRequest;
import org.cloudfoundry.uaa.groups.UpdateGroupResponse;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public class ReactorGroups
extends AbstractUaaOperations
implements Groups {
    public ReactorGroups(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<AddMemberResponse> addMember(AddMemberRequest request) {
        return this.post(request, AddMemberResponse.class, builder -> builder.pathSegment(new String[]{"Groups", request.getGroupId(), "members"}));
    }

    public Mono<CheckMembershipResponse> checkMembership(CheckMembershipRequest request) {
        return this.get(request, CheckMembershipResponse.class, builder -> builder.pathSegment(new String[]{"Groups", request.getGroupId(), "members", request.getMemberId()}));
    }

    public Mono<CreateGroupResponse> create(CreateGroupRequest request) {
        return this.post(request, CreateGroupResponse.class, builder -> builder.pathSegment(new String[]{"Groups"}));
    }

    public Mono<DeleteGroupResponse> delete(DeleteGroupRequest request) {
        return this.delete(request, DeleteGroupResponse.class, builder -> builder.pathSegment(new String[]{"Groups", request.getGroupId()}));
    }

    public Mono<GetGroupResponse> get(GetGroupRequest request) {
        return this.get(request, GetGroupResponse.class, builder -> builder.pathSegment(new String[]{"Groups", request.getGroupId()}));
    }

    public Mono<ListGroupsResponse> list(ListGroupsRequest request) {
        return this.get(request, ListGroupsResponse.class, builder -> builder.pathSegment(new String[]{"Groups"}));
    }

    public Mono<ListExternalGroupMappingsResponse> listExternalGroupMappings(ListExternalGroupMappingsRequest request) {
        return this.get(request, ListExternalGroupMappingsResponse.class, builder -> builder.pathSegment(new String[]{"Groups", "External"}));
    }

    public Mono<ListMembersResponse> listMembers(ListMembersRequest request) {
        return this.get(request, ListMembersResponse.class, builder -> builder.pathSegment(new String[]{"Groups", request.getGroupId(), "members"}));
    }

    public Mono<MapExternalGroupResponse> mapExternalGroup(MapExternalGroupRequest request) {
        return this.post(request, MapExternalGroupResponse.class, builder -> builder.pathSegment(new String[]{"Groups", "External"}));
    }

    public Mono<RemoveMemberResponse> removeMember(RemoveMemberRequest request) {
        return this.delete(request, RemoveMemberResponse.class, builder -> builder.pathSegment(new String[]{"Groups", request.getGroupId(), "members", request.getMemberId()}));
    }

    public Mono<UnmapExternalGroupByGroupDisplayNameResponse> unmapExternalGroupByGroupDisplayName(UnmapExternalGroupByGroupDisplayNameRequest request) {
        return this.delete(request, UnmapExternalGroupByGroupDisplayNameResponse.class, builder -> builder.pathSegment(new String[]{"Groups", "External", "displayName", request.getGroupDisplayName(), "externalGroup", request.getExternalGroup(), "origin", request.getOriginKey()}));
    }

    public Mono<UnmapExternalGroupByGroupIdResponse> unmapExternalGroupByGroupId(UnmapExternalGroupByGroupIdRequest request) {
        return this.delete(request, UnmapExternalGroupByGroupIdResponse.class, builder -> builder.pathSegment(new String[]{"Groups", "External", "groupId", request.getGroupId(), "externalGroup", request.getExternalGroup(), "origin", request.getOriginKey()}));
    }

    public Mono<UpdateGroupResponse> update(UpdateGroupRequest request) {
        return this.put(request, UpdateGroupResponse.class, builder -> builder.pathSegment(new String[]{"Groups", request.getGroupId()}));
    }
}

