/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa.tokens;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.reactor.uaa.AbstractUaaOperations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.uaa.ResponseType;
import org.cloudfoundry.uaa.tokens.CheckTokenRequest;
import org.cloudfoundry.uaa.tokens.CheckTokenResponse;
import org.cloudfoundry.uaa.tokens.GetTokenByAuthorizationCodeRequest;
import org.cloudfoundry.uaa.tokens.GetTokenByAuthorizationCodeResponse;
import org.cloudfoundry.uaa.tokens.GetTokenByClientCredentialsRequest;
import org.cloudfoundry.uaa.tokens.GetTokenByClientCredentialsResponse;
import org.cloudfoundry.uaa.tokens.GetTokenByOneTimePasscodeRequest;
import org.cloudfoundry.uaa.tokens.GetTokenByOneTimePasscodeResponse;
import org.cloudfoundry.uaa.tokens.GetTokenByOpenIdRequest;
import org.cloudfoundry.uaa.tokens.GetTokenByOpenIdResponse;
import org.cloudfoundry.uaa.tokens.GetTokenByPasswordRequest;
import org.cloudfoundry.uaa.tokens.GetTokenByPasswordResponse;
import org.cloudfoundry.uaa.tokens.GetTokenKeyRequest;
import org.cloudfoundry.uaa.tokens.GetTokenKeyResponse;
import org.cloudfoundry.uaa.tokens.ListTokenKeysRequest;
import org.cloudfoundry.uaa.tokens.ListTokenKeysResponse;
import org.cloudfoundry.uaa.tokens.RefreshTokenRequest;
import org.cloudfoundry.uaa.tokens.RefreshTokenResponse;
import org.cloudfoundry.uaa.tokens.Tokens;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorTokens
extends AbstractUaaOperations
implements Tokens {
    public ReactorTokens(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<CheckTokenResponse> check(CheckTokenRequest request) {
        return this.post(request, CheckTokenResponse.class, builder -> builder.pathSegment(new String[]{"check_token"}));
    }

    public Mono<GetTokenByAuthorizationCodeResponse> getByAuthorizationCode(GetTokenByAuthorizationCodeRequest request) {
        return this.postForm(request, GetTokenByAuthorizationCodeResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{"authorization_code"}).queryParam("response_type", new Object[]{ResponseType.TOKEN}));
    }

    public Mono<GetTokenByClientCredentialsResponse> getByClientCredentials(GetTokenByClientCredentialsRequest request) {
        return this.postForm(request, GetTokenByClientCredentialsResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{"client_credentials"}).queryParam("response_type", new Object[]{ResponseType.TOKEN}));
    }

    public Mono<GetTokenByOneTimePasscodeResponse> getByOneTimePasscode(GetTokenByOneTimePasscodeRequest request) {
        return this.postForm(request, GetTokenByOneTimePasscodeResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{"password"}).queryParam("response_type", new Object[]{ResponseType.TOKEN}));
    }

    public Mono<GetTokenByOpenIdResponse> getByOpenId(GetTokenByOpenIdRequest request) {
        return this.postForm(request, GetTokenByOpenIdResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{"authorization_code"}).queryParam("response_type", new Object[]{ResponseType.ID_TOKEN}));
    }

    public Mono<GetTokenByPasswordResponse> getByPassword(GetTokenByPasswordRequest request) {
        return this.postForm(request, GetTokenByPasswordResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{"password"}).queryParam("response_type", new Object[]{ResponseType.TOKEN}));
    }

    public Mono<GetTokenKeyResponse> getKey(GetTokenKeyRequest request) {
        return this.get(request, GetTokenKeyResponse.class, builder -> builder.pathSegment(new String[]{"token_key"}));
    }

    public Mono<ListTokenKeysResponse> listKeys(ListTokenKeysRequest request) {
        return this.get(request, ListTokenKeysResponse.class, builder -> builder.pathSegment(new String[]{"token_keys"}));
    }

    public Mono<RefreshTokenResponse> refresh(RefreshTokenRequest request) {
        return this.postForm(request, RefreshTokenResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{"refresh_token"}));
    }
}

