/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa.users;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.reactor.uaa.AbstractUaaOperations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.uaa.users.ChangeUserPasswordRequest;
import org.cloudfoundry.uaa.users.ChangeUserPasswordResponse;
import org.cloudfoundry.uaa.users.CreateUserRequest;
import org.cloudfoundry.uaa.users.CreateUserResponse;
import org.cloudfoundry.uaa.users.DeleteUserRequest;
import org.cloudfoundry.uaa.users.DeleteUserResponse;
import org.cloudfoundry.uaa.users.GetUserVerificationLinkRequest;
import org.cloudfoundry.uaa.users.GetUserVerificationLinkResponse;
import org.cloudfoundry.uaa.users.InviteUsersRequest;
import org.cloudfoundry.uaa.users.InviteUsersResponse;
import org.cloudfoundry.uaa.users.ListUsersRequest;
import org.cloudfoundry.uaa.users.ListUsersResponse;
import org.cloudfoundry.uaa.users.LookupUserIdsRequest;
import org.cloudfoundry.uaa.users.LookupUserIdsResponse;
import org.cloudfoundry.uaa.users.UpdateUserRequest;
import org.cloudfoundry.uaa.users.UpdateUserResponse;
import org.cloudfoundry.uaa.users.Users;
import org.cloudfoundry.uaa.users.VerifyUserRequest;
import org.cloudfoundry.uaa.users.VerifyUserResponse;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorUsers
extends AbstractUaaOperations
implements Users {
    public ReactorUsers(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<ChangeUserPasswordResponse> changePassword(ChangeUserPasswordRequest request) {
        return this.put(request, ChangeUserPasswordResponse.class, builder -> builder.pathSegment(new String[]{"Users", request.getUserId(), "password"}));
    }

    public Mono<CreateUserResponse> create(CreateUserRequest request) {
        return this.post(request, CreateUserResponse.class, builder -> builder.pathSegment(new String[]{"Users"}));
    }

    public Mono<DeleteUserResponse> delete(DeleteUserRequest request) {
        return this.delete(request, DeleteUserResponse.class, builder -> builder.pathSegment(new String[]{"Users", request.getUserId()}));
    }

    public Mono<GetUserVerificationLinkResponse> getVerificationLink(GetUserVerificationLinkRequest request) {
        return this.get(request, GetUserVerificationLinkResponse.class, builder -> builder.pathSegment(new String[]{"Users", request.getUserId(), "verify-link"}));
    }

    public Mono<InviteUsersResponse> invite(InviteUsersRequest request) {
        return this.post(request, InviteUsersResponse.class, builder -> builder.pathSegment(new String[]{"invite_users"}));
    }

    public Mono<ListUsersResponse> list(ListUsersRequest request) {
        return this.get(request, ListUsersResponse.class, builder -> builder.pathSegment(new String[]{"Users"}));
    }

    public Mono<LookupUserIdsResponse> lookup(LookupUserIdsRequest request) {
        return this.get(request, LookupUserIdsResponse.class, builder -> builder.pathSegment(new String[]{"ids", "Users"}));
    }

    public Mono<UpdateUserResponse> update(UpdateUserRequest request) {
        return this.put(request, UpdateUserResponse.class, builder -> builder.pathSegment(new String[]{"Users", request.getId()}));
    }

    public Mono<VerifyUserResponse> verify(VerifyUserRequest request) {
        return this.get(request, VerifyUserResponse.class, builder -> builder.pathSegment(new String[]{"Users", request.getUserId(), "verify"}));
    }
}

