/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.util.AsciiString;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.reactor.util.JsonCodec;
import org.cloudfoundry.reactor.util.JsonParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;
import reactor.io.netty.http.HttpClientRequest;
import reactor.io.netty.http.HttpClientResponse;
import reactor.io.netty.http.HttpException;
import reactor.io.netty.http.HttpOutbound;

public abstract class AbstractReactorOperations {
    protected static final AsciiString APPLICATION_JSON = new AsciiString((CharSequence)"application/json");
    protected static final AsciiString APPLICATION_X_WWW_FORM_URLENCODED = new AsciiString((CharSequence)"application/x-www-form-urlencoded");
    protected static final AsciiString APPLICATION_ZIP = new AsciiString((CharSequence)"application/zip");
    protected static final AsciiString AUTHORIZATION = new AsciiString((CharSequence)"Authorization");
    protected static final AsciiString CONTENT_TYPE = new AsciiString((CharSequence)"Content-Type");
    private static final String CF_WARNINGS = "X-Cf-Warnings";
    private final AuthorizationProvider authorizationProvider;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final Logger requestLogger = LoggerFactory.getLogger((String)"cloudfoundry-client.request");
    private final Logger responseLogger = LoggerFactory.getLogger((String)"cloudfoundry-client.response");
    private final Mono<String> root;

    protected AbstractReactorOperations(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        this.authorizationProvider = authorizationProvider;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.root = root;
    }

    protected final <T> Mono<T> doDelete(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.root.map(root -> AbstractReactorOperations.buildUri(root, uriTransformer)).then(uri -> this.httpClient.delete(uri, outbound -> this.authorizationProvider.addAuthorization((HttpClientRequest)outbound).map(requestTransformer).then(o -> o.send(this.serializedRequest((HttpClientRequest)o, request)))).doOnSubscribe(s -> this.requestLogger.debug("DELETE {}", uri)).compose(this.logResponse((String)uri))).compose(this.deserializedResponse(responseType));
    }

    protected final <T> Mono<T> doGet(Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.doGet(uriTransformer, requestTransformer).compose(this.deserializedResponse(responseType));
    }

    protected final Mono<HttpClientResponse> doGet(Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.root.map(root -> AbstractReactorOperations.buildUri(root, uriTransformer)).then(uri -> this.httpClient.get(uri, outbound -> this.authorizationProvider.addAuthorization((HttpClientRequest)outbound).map(requestTransformer).then(HttpOutbound::sendHeaders)).doOnSubscribe(s -> this.requestLogger.debug("GET    {}", uri)).compose(this.logResponse((String)uri)));
    }

    protected final Mono<HttpClientResponse> doGetNoAuth(Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.root.map(root -> AbstractReactorOperations.buildUri(root, uriTransformer)).then(uri -> this.httpClient.get(uri, outbound -> Mono.just((Object)outbound).map(requestTransformer).then(HttpOutbound::sendHeaders)).doOnSubscribe(s -> this.requestLogger.debug("GET    {}", uri)).compose(this.logResponse((String)uri)));
    }

    protected final <T> Mono<T> doPatch(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.root.map(root -> AbstractReactorOperations.buildUri(root, uriTransformer)).then(uri -> this.httpClient.patch(uri, outbound -> this.authorizationProvider.addAuthorization((HttpClientRequest)outbound).map(requestTransformer).then(o -> o.send(this.serializedRequest((HttpClientRequest)o, request)))).doOnSubscribe(s -> this.requestLogger.debug("PATCH  {}", uri)).compose(this.logResponse((String)uri))).compose(this.deserializedResponse(responseType));
    }

    protected final <T> Mono<T> doPost(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.doPost(responseType, uriTransformer, outbound -> ((HttpClientRequest)requestTransformer.apply((HttpClientRequest)outbound)).send(this.serializedRequest((HttpClientRequest)outbound, request)));
    }

    protected final <T> Mono<T> doPost(Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, Mono<Void>> requestTransformer) {
        return this.root.map(root -> AbstractReactorOperations.buildUri(root, uriTransformer)).then(uri -> this.httpClient.post(uri, outbound -> this.authorizationProvider.addAuthorization((HttpClientRequest)outbound).then(requestTransformer)).doOnSubscribe(s -> this.requestLogger.debug("POST   {}", uri)).compose(this.logResponse((String)uri))).compose(this.deserializedResponse(responseType));
    }

    protected final <T> Mono<T> doPut(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.root.map(root -> AbstractReactorOperations.buildUri(root, uriTransformer)).then(uri -> this.httpClient.put(uri, outbound -> this.authorizationProvider.addAuthorization((HttpClientRequest)outbound).map(requestTransformer).then(o -> o.send(this.serializedRequest((HttpClientRequest)o, request)))).doOnSubscribe(s -> this.requestLogger.debug("PUT    {}", uri)).compose(this.logResponse((String)uri))).compose(this.deserializedResponse(responseType));
    }

    protected final <T> Mono<T> doPut(Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, Mono<Void>> requestTransformer) {
        return this.root.map(root -> AbstractReactorOperations.buildUri(root, uriTransformer)).then(uri -> this.httpClient.put(uri, outbound -> this.authorizationProvider.addAuthorization((HttpClientRequest)outbound).then(requestTransformer)).doOnSubscribe(s -> this.requestLogger.debug("PUT    {}", uri)).compose(this.logResponse((String)uri))).compose(this.deserializedResponse(responseType));
    }

    protected final Mono<HttpClientResponse> doWs(Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.root.map(root -> AbstractReactorOperations.buildUri(root, uriTransformer)).then(uri -> this.httpClient.get(uri, outbound -> this.authorizationProvider.addAuthorization((HttpClientRequest)outbound).map(requestTransformer).then(HttpOutbound::upgradeToTextWebsocket)).doOnSubscribe(s -> this.requestLogger.debug("WS     {}", uri)).compose(this.logResponse((String)uri)));
    }

    private static String buildUri(String root, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return uriTransformer.apply(UriComponentsBuilder.fromUriString((String)root)).build().encode().toUriString();
    }

    private <T> Function<Mono<HttpClientResponse>, Mono<T>> deserializedResponse(Class<T> responseType) {
        return inbound -> inbound.then(i -> i.receive().aggregate().toInputStream()).map(JsonCodec.decode(this.objectMapper, responseType)).doOnError(JsonParsingException.class, e -> this.responseLogger.debug("\n{}", (Object)e.getPayload()));
    }

    private Function<Mono<HttpClientResponse>, Mono<HttpClientResponse>> logResponse(String uri) {
        return inbound -> inbound.doOnSuccess(i -> {
            List warnings = i.responseHeaders().getAll(CF_WARNINGS);
            if (warnings.isEmpty()) {
                this.responseLogger.debug("{}    {}", (Object)i.status().code(), (Object)uri);
            } else {
                this.responseLogger.warn("{}    {} ({})", new Object[]{i.status().code(), uri, StringUtils.collectionToCommaDelimitedString((Collection)warnings)});
            }
        }).doOnError(t -> {
            if (t instanceof HttpException) {
                this.responseLogger.debug("{}    {}", (Object)((HttpException)t).getResponseStatus().code(), (Object)uri);
            }
        });
    }

    private Mono<ByteBuf> serializedRequest(HttpClientRequest outbound, Object request) {
        return Mono.just((Object)request).filter(req -> this.objectMapper.canSerialize(req.getClass())).map(JsonCodec.encode(this.objectMapper, outbound));
    }
}

