/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.reactor.util.ConnectionContext;
import org.cloudfoundry.reactor.util.ProxyContext;
import org.cloudfoundry.reactor.util.SslCertificateTruster;
import org.cloudfoundry.reactor.util._DefaultConnectionContext;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class DefaultConnectionContext
extends _DefaultConnectionContext {
    private final AuthorizationProvider authorizationProvider;
    private final String clientId;
    private final String clientSecret;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final Mono<String> root;
    private final String host;
    private final Mono<Map<String, String>> info;
    @Nullable
    private final Integer port;
    private final ProxyContext proxyContext;
    @Nullable
    private final String proxyHost;
    @Nullable
    private final String proxyPassword;
    @Nullable
    private final Integer proxyPort;
    @Nullable
    private final String proxyUsername;
    private final Optional<SslCertificateTruster> sslCertificateTruster;
    @Nullable
    private final Boolean trustCertificates;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private DefaultConnectionContext(Builder builder) {
        this.authorizationProvider = builder.authorizationProvider;
        this.host = builder.host;
        this.port = builder.port;
        this.proxyHost = builder.proxyHost;
        this.proxyPassword = builder.proxyPassword;
        this.proxyPort = builder.proxyPort;
        this.proxyUsername = builder.proxyUsername;
        this.trustCertificates = builder.trustCertificates;
        if (builder.clientId != null) {
            this.initShim.clientId(builder.clientId);
        }
        if (builder.clientSecret != null) {
            this.initShim.clientSecret(builder.clientSecret);
        }
        if (builder.objectMapper != null) {
            this.initShim.objectMapper(builder.objectMapper);
        }
        this.clientId = this.initShim.getClientId();
        this.clientSecret = this.initShim.getClientSecret();
        this.objectMapper = this.initShim.getObjectMapper();
        this.httpClient = this.initShim.getHttpClient();
        this.root = this.initShim.getRoot();
        this.info = this.initShim.getInfo();
        this.proxyContext = this.initShim.getProxyContext();
        this.sslCertificateTruster = this.initShim.getSslCertificateTruster();
        this.initShim = null;
    }

    @Override
    public AuthorizationProvider getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    @Override
    public String getClientId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClientId() : this.clientId;
    }

    @Override
    public String getClientSecret() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClientSecret() : this.clientSecret;
    }

    @Override
    public HttpClient getHttpClient() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getHttpClient() : this.httpClient;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectMapper() : this.objectMapper;
    }

    @Override
    public Mono<String> getRoot() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRoot() : this.root;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Mono<Map<String, String>> getInfo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getInfo() : this.info;
    }

    @Override
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    public ProxyContext getProxyContext() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getProxyContext() : this.proxyContext;
    }

    @Override
    @Nullable
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    @Nullable
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    @Nullable
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Override
    @Nullable
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Override
    public Optional<SslCertificateTruster> getSslCertificateTruster() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSslCertificateTruster() : this.sslCertificateTruster;
    }

    @Override
    @Nullable
    public Boolean getTrustCertificates() {
        return this.trustCertificates;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DefaultConnectionContext && this.equalTo((DefaultConnectionContext)another);
    }

    private boolean equalTo(DefaultConnectionContext another) {
        return this.authorizationProvider.equals(another.authorizationProvider) && this.clientId.equals(another.clientId) && this.clientSecret.equals(another.clientSecret) && this.httpClient.equals(another.httpClient) && this.objectMapper.equals(another.objectMapper) && this.root.equals(another.root) && this.host.equals(another.host) && this.info.equals(another.info) && Objects.equals(this.port, another.port) && this.proxyContext.equals(another.proxyContext) && Objects.equals(this.proxyHost, another.proxyHost) && Objects.equals(this.proxyPassword, another.proxyPassword) && Objects.equals(this.proxyPort, another.proxyPort) && Objects.equals(this.proxyUsername, another.proxyUsername) && this.sslCertificateTruster.equals(another.sslCertificateTruster) && Objects.equals(this.trustCertificates, another.trustCertificates);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.authorizationProvider.hashCode();
        h = h * 17 + this.clientId.hashCode();
        h = h * 17 + this.clientSecret.hashCode();
        h = h * 17 + this.httpClient.hashCode();
        h = h * 17 + this.objectMapper.hashCode();
        h = h * 17 + this.root.hashCode();
        h = h * 17 + this.host.hashCode();
        h = h * 17 + this.info.hashCode();
        h = h * 17 + Objects.hashCode(this.port);
        h = h * 17 + this.proxyContext.hashCode();
        h = h * 17 + Objects.hashCode(this.proxyHost);
        h = h * 17 + Objects.hashCode(this.proxyPassword);
        h = h * 17 + Objects.hashCode(this.proxyPort);
        h = h * 17 + Objects.hashCode(this.proxyUsername);
        h = h * 17 + this.sslCertificateTruster.hashCode();
        h = h * 17 + Objects.hashCode(this.trustCertificates);
        return h;
    }

    public String toString() {
        return "DefaultConnectionContext{authorizationProvider=" + this.authorizationProvider + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", httpClient=" + this.httpClient + ", objectMapper=" + this.objectMapper + ", root=" + this.root + ", host=" + this.host + ", info=" + this.info + ", port=" + this.port + ", proxyContext=" + this.proxyContext + ", proxyHost=" + this.proxyHost + ", proxyPassword=" + this.proxyPassword + ", proxyPort=" + this.proxyPort + ", proxyUsername=" + this.proxyUsername + ", sslCertificateTruster=" + this.sslCertificateTruster + ", trustCertificates=" + this.trustCertificates + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_AUTHORIZATION_PROVIDER = 1L;
        private static final long INIT_BIT_HOST = 2L;
        private long initBits = 3L;
        private AuthorizationProvider authorizationProvider;
        private String clientId;
        private String clientSecret;
        private ObjectMapper objectMapper;
        private String host;
        private Integer port;
        private String proxyHost;
        private String proxyPassword;
        private Integer proxyPort;
        private String proxyUsername;
        private Boolean trustCertificates;

        private Builder() {
        }

        public final Builder from(ConnectionContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DefaultConnectionContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_DefaultConnectionContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ConnectionContext instance;
            long bits = 0L;
            if (object instanceof ConnectionContext) {
                instance = (ConnectionContext)object;
                if ((bits & 4L) == 0L) {
                    this.authorizationProvider(instance.getAuthorizationProvider());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.clientSecret(instance.getClientSecret());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.clientId(instance.getClientId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.objectMapper(instance.getObjectMapper());
                    bits |= 2L;
                }
            }
            if (object instanceof _DefaultConnectionContext) {
                Boolean trustCertificatesValue;
                String proxyHostValue;
                String proxyUsernameValue;
                Integer portValue;
                instance = (_DefaultConnectionContext)object;
                Integer proxyPortValue = ((_DefaultConnectionContext)instance).getProxyPort();
                if (proxyPortValue != null) {
                    this.proxyPort(proxyPortValue);
                }
                if ((bits & 1L) == 0L) {
                    this.clientId(((_DefaultConnectionContext)instance).getClientId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.objectMapper(((_DefaultConnectionContext)instance).getObjectMapper());
                    bits |= 2L;
                }
                if ((portValue = ((_DefaultConnectionContext)instance).getPort()) != null) {
                    this.port(portValue);
                }
                if ((proxyUsernameValue = ((_DefaultConnectionContext)instance).getProxyUsername()) != null) {
                    this.proxyUsername(proxyUsernameValue);
                }
                this.host(((_DefaultConnectionContext)instance).getHost());
                String proxyPasswordValue = ((_DefaultConnectionContext)instance).getProxyPassword();
                if (proxyPasswordValue != null) {
                    this.proxyPassword(proxyPasswordValue);
                }
                if ((bits & 4L) == 0L) {
                    this.authorizationProvider(((_DefaultConnectionContext)instance).getAuthorizationProvider());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.clientSecret(((_DefaultConnectionContext)instance).getClientSecret());
                    bits |= 8L;
                }
                if ((proxyHostValue = ((_DefaultConnectionContext)instance).getProxyHost()) != null) {
                    this.proxyHost(proxyHostValue);
                }
                if ((trustCertificatesValue = ((_DefaultConnectionContext)instance).getTrustCertificates()) != null) {
                    this.trustCertificates(trustCertificatesValue);
                }
            }
        }

        public final Builder authorizationProvider(AuthorizationProvider authorizationProvider) {
            this.authorizationProvider = Objects.requireNonNull(authorizationProvider, "authorizationProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            return this;
        }

        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            return this;
        }

        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            return this;
        }

        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public final Builder proxyHost(@Nullable String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public final Builder proxyPassword(@Nullable String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public final Builder proxyPort(@Nullable Integer proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public final Builder proxyUsername(@Nullable String proxyUsername) {
            this.proxyUsername = proxyUsername;
            return this;
        }

        public final Builder trustCertificates(@Nullable Boolean trustCertificates) {
            this.trustCertificates = trustCertificates;
            return this;
        }

        public DefaultConnectionContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DefaultConnectionContext(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authorizationProvider");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("host");
            }
            return "Cannot build DefaultConnectionContext, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private String clientId;
        private int clientIdStage;
        private String clientSecret;
        private int clientSecretStage;
        private HttpClient httpClient;
        private int httpClientStage;
        private ObjectMapper objectMapper;
        private int objectMapperStage;
        private Mono<String> root;
        private int rootStage;
        private Mono<Map<String, String>> info;
        private int infoStage;
        private ProxyContext proxyContext;
        private int proxyContextStage;
        private Optional<SslCertificateTruster> sslCertificateTruster;
        private int sslCertificateTrusterStage;

        private InitShim() {
        }

        String getClientId() {
            if (this.clientIdStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientIdStage == 0) {
                this.clientIdStage = -1;
                this.clientId = Objects.requireNonNull(DefaultConnectionContext.super.getClientId(), "clientId");
                this.clientIdStage = 1;
            }
            return this.clientId;
        }

        void clientId(String clientId) {
            this.clientId = clientId;
            this.clientIdStage = 1;
        }

        String getClientSecret() {
            if (this.clientSecretStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientSecretStage == 0) {
                this.clientSecretStage = -1;
                this.clientSecret = Objects.requireNonNull(DefaultConnectionContext.super.getClientSecret(), "clientSecret");
                this.clientSecretStage = 1;
            }
            return this.clientSecret;
        }

        void clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            this.clientSecretStage = 1;
        }

        HttpClient getHttpClient() {
            if (this.httpClientStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.httpClientStage == 0) {
                this.httpClientStage = -1;
                this.httpClient = Objects.requireNonNull(DefaultConnectionContext.super.getHttpClient(), "httpClient");
                this.httpClientStage = 1;
            }
            return this.httpClient;
        }

        ObjectMapper getObjectMapper() {
            if (this.objectMapperStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMapperStage == 0) {
                this.objectMapperStage = -1;
                this.objectMapper = Objects.requireNonNull(DefaultConnectionContext.super.getObjectMapper(), "objectMapper");
                this.objectMapperStage = 1;
            }
            return this.objectMapper;
        }

        void objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectMapperStage = 1;
        }

        Mono<String> getRoot() {
            if (this.rootStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rootStage == 0) {
                this.rootStage = -1;
                this.root = Objects.requireNonNull(DefaultConnectionContext.super.getRoot(), "root");
                this.rootStage = 1;
            }
            return this.root;
        }

        Mono<Map<String, String>> getInfo() {
            if (this.infoStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.infoStage == 0) {
                this.infoStage = -1;
                this.info = Objects.requireNonNull(DefaultConnectionContext.super.getInfo(), "info");
                this.infoStage = 1;
            }
            return this.info;
        }

        ProxyContext getProxyContext() {
            if (this.proxyContextStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.proxyContextStage == 0) {
                this.proxyContextStage = -1;
                this.proxyContext = Objects.requireNonNull(DefaultConnectionContext.super.getProxyContext(), "proxyContext");
                this.proxyContextStage = 1;
            }
            return this.proxyContext;
        }

        Optional<SslCertificateTruster> getSslCertificateTruster() {
            if (this.sslCertificateTrusterStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sslCertificateTrusterStage == 0) {
                this.sslCertificateTrusterStage = -1;
                this.sslCertificateTruster = Objects.requireNonNull(DefaultConnectionContext.super.getSslCertificateTruster(), "sslCertificateTruster");
                this.sslCertificateTrusterStage = 1;
            }
            return this.sslCertificateTruster;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.clientIdStage == -1) {
                attributes.add("clientId");
            }
            if (this.clientSecretStage == -1) {
                attributes.add("clientSecret");
            }
            if (this.httpClientStage == -1) {
                attributes.add("httpClient");
            }
            if (this.objectMapperStage == -1) {
                attributes.add("objectMapper");
            }
            if (this.rootStage == -1) {
                attributes.add("root");
            }
            if (this.infoStage == -1) {
                attributes.add("info");
            }
            if (this.proxyContextStage == -1) {
                attributes.add("proxyContext");
            }
            if (this.sslCertificateTrusterStage == -1) {
                attributes.add("sslCertificateTruster");
            }
            return "Cannot build DefaultConnectionContext, attribute initializers form cycle" + attributes;
        }
    }
}

