/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.cloudfoundry.reactor.util.JsonParsingException;
import reactor.core.util.Exceptions;
import reactor.io.netty.http.HttpClientRequest;

final class JsonCodec {
    private static final AsciiString APPLICATION_JSON = new AsciiString((CharSequence)"application/json; charset=utf-8");
    private static final AsciiString CONTENT_TYPE = new AsciiString((CharSequence)"Content-Type");

    JsonCodec() {
    }

    static <T> Function<InputStream, T> decode(ObjectMapper objectMapper, Class<T> type) {
        return inputStream -> {
            try (InputStream in = inputStream;){
                Object object = objectMapper.readValue(in, type);
                return object;
            }
            catch (IOException e) {
                throw new JsonParsingException("Unable to parse JSON Payload", e, (InputStream)inputStream);
            }
        };
    }

    static <T> Function<T, ByteBuf> encode(ObjectMapper objectMapper, HttpClientRequest request) {
        request.header((CharSequence)CONTENT_TYPE, (CharSequence)APPLICATION_JSON);
        return source -> JsonCodec.encode(request.delegate().alloc(), objectMapper, source);
    }

    static <T> ByteBuf encode(ByteBufAllocator allocator, ObjectMapper objectMapper, T source) {
        try {
            return allocator.directBuffer().writeBytes(objectMapper.writeValueAsBytes(source));
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

