/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import reactor.core.util.Exceptions;

final class JsonParsingException
extends RuntimeException {
    private static final long serialVersionUID = 689280281752742553L;
    private final String payload;

    JsonParsingException(String message, Throwable cause, InputStream in) {
        super(message, cause);
        this.payload = JsonParsingException.getPayload(in);
    }

    public String getPayload() {
        return this.payload;
    }

    private static String getPayload(InputStream in) {
        StringBuilder sb = new StringBuilder();
        try {
            in.reset();
            try (InputStreamReader reader = new InputStreamReader(in, Charset.forName("UTF-8"));){
                int length;
                char[] buffer = new char[8192];
                while ((length = reader.read(buffer)) != -1) {
                    sb.append(buffer, 0, length);
                }
            }
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return sb.toString();
    }
}

