/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import org.cloudfoundry.reactor.util.JsonCodec;
import reactor.core.publisher.Mono;
import reactor.core.util.Exceptions;
import reactor.io.netty.http.HttpClientRequest;

public final class MultipartHttpClientRequest {
    private static final byte[] BOUNDARY_CHARS = new byte[]{45, 95, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static final AsciiString BOUNDARY_PREAMBLE = new AsciiString((CharSequence)"; boundary=");
    private static final AsciiString CONTENT_DISPOSITION = new AsciiString((CharSequence)"Content-Disposition");
    private static final AsciiString CONTENT_LENGTH = new AsciiString((CharSequence)"Content-Length");
    private static final AsciiString CONTENT_TYPE = new AsciiString((CharSequence)"Content-Type");
    private static final AsciiString CRLF = new AsciiString((CharSequence)"\r\n");
    private static final AsciiString DOUBLE_DASH = new AsciiString((CharSequence)"--");
    private static final AsciiString HEADER_DELIMITER = new AsciiString((CharSequence)": ");
    private static final AsciiString MULTIPART_FORM_DATA = new AsciiString((CharSequence)"multipart/form-data");
    private static final Random RND = new Random();
    private final ObjectMapper objectMapper;
    private final HttpClientRequest outbound;
    private final List<Consumer<PartHttpClientRequest>> partConsumers = new ArrayList<Consumer<PartHttpClientRequest>>();

    public MultipartHttpClientRequest(ObjectMapper objectMapper, HttpClientRequest outbound) {
        this.objectMapper = objectMapper;
        this.outbound = outbound;
    }

    public MultipartHttpClientRequest addPart(Consumer<PartHttpClientRequest> partConsumer) {
        this.partConsumers.add(partConsumer);
        return this;
    }

    public Mono<Void> done() {
        AsciiString boundary = MultipartHttpClientRequest.generateMultipartBoundary();
        ByteBufAllocator allocator = this.outbound.delegate().alloc();
        CompositeByteBuf bodyBuf = allocator.compositeBuffer();
        this.partConsumers.forEach(partConsumer -> bodyBuf.addComponent(MultipartHttpClientRequest.getPart(allocator, boundary, this.objectMapper, partConsumer)));
        bodyBuf.addComponent(MultipartHttpClientRequest.getCloseDelimiter(allocator, boundary));
        return this.outbound.removeTransferEncodingChunked().addHeader((CharSequence)CONTENT_TYPE, (CharSequence)MULTIPART_FORM_DATA.concat((CharSequence)BOUNDARY_PREAMBLE).concat((CharSequence)boundary)).addHeader((CharSequence)CONTENT_LENGTH, (CharSequence)String.valueOf(bodyBuf.capacity())).sendOne((Object)bodyBuf.writerIndex(bodyBuf.capacity()));
    }

    private static AsciiString generateMultipartBoundary() {
        byte[] boundary = new byte[RND.nextInt(11) + 30];
        for (int i = 0; i < boundary.length; ++i) {
            boundary[i] = BOUNDARY_CHARS[RND.nextInt(BOUNDARY_CHARS.length)];
        }
        return new AsciiString(boundary);
    }

    private static ByteBuf getCloseDelimiter(ByteBufAllocator allocator, AsciiString boundary) {
        AsciiString s = DOUBLE_DASH.concat((CharSequence)boundary).concat((CharSequence)DOUBLE_DASH);
        return allocator.directBuffer(s.length()).writeBytes(s.toByteArray());
    }

    private static ByteBuf getDelimiter(ByteBufAllocator allocator, AsciiString boundary) {
        AsciiString s = DOUBLE_DASH.concat((CharSequence)boundary).concat((CharSequence)CRLF);
        return allocator.directBuffer(s.length()).writeBytes(s.toByteArray());
    }

    private static ByteBuf getPart(ByteBufAllocator allocator, AsciiString boundary, ObjectMapper objectMapper, Consumer<PartHttpClientRequest> partConsumer) {
        PartHttpClientRequest part = new PartHttpClientRequest(objectMapper);
        partConsumer.accept(part);
        CompositeByteBuf body = allocator.compositeBuffer();
        body.addComponent(MultipartHttpClientRequest.getDelimiter(allocator, boundary));
        body.addComponent(part.getHeaders(allocator));
        body.addComponent(part.getData(allocator));
        return body.writerIndex(body.capacity());
    }

    public static final class PartHttpClientRequest {
        private final HttpHeaders headers = new DefaultHttpHeaders(true);
        private final ObjectMapper objectMapper;
        private InputStream inputStream;
        private Object source;

        private PartHttpClientRequest(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public PartHttpClientRequest addHeader(CharSequence name, CharSequence value) {
            this.headers.add(name, (Object)value);
            return this;
        }

        public void send(Object source) {
            this.source = source;
        }

        public void sendInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public PartHttpClientRequest setContentDispositionFormData(String name) {
            return this.setContentDispositionFormData(name, null);
        }

        public PartHttpClientRequest setContentDispositionFormData(String name, String filename) {
            StringBuilder sb = new StringBuilder("form-data; name=\"");
            sb.append(name).append('\"');
            if (filename != null) {
                sb.append("; filename=\"");
                sb.append(filename).append('\"');
            }
            this.headers.add((CharSequence)CONTENT_DISPOSITION, (Object)sb);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static ByteBuf getData(ByteBufAllocator allocator, InputStream inputStream) {
            try (InputStream in = inputStream;){
                ByteBuf byteBuf = allocator.directBuffer(in.available());
                byteBuf.writeBytes(inputStream, inputStream.available());
                ByteBuf byteBuf2 = byteBuf;
                return byteBuf2;
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        private static ByteBuf getData(ByteBufAllocator allocator, ObjectMapper objectMapper, Object source) {
            return JsonCodec.encode(allocator, objectMapper, source);
        }

        private ByteBuf getData(ByteBufAllocator allocator) {
            CompositeByteBuf dataBuf = allocator.compositeBuffer();
            dataBuf.addComponent(allocator.directBuffer(CRLF.length()).writeBytes(CRLF.toByteArray()));
            if (this.inputStream != null) {
                dataBuf.addComponent(PartHttpClientRequest.getData(allocator, this.inputStream));
            } else if (this.source != null) {
                dataBuf.addComponent(PartHttpClientRequest.getData(allocator, this.objectMapper, this.source));
            }
            dataBuf.addComponent(allocator.directBuffer(CRLF.length()).writeBytes(CRLF.toByteArray()));
            return dataBuf.writerIndex(dataBuf.capacity());
        }

        private ByteBuf getHeaders(ByteBufAllocator allocator) {
            AsciiString s = AsciiString.EMPTY_STRING;
            for (Map.Entry entry : this.headers) {
                s = s.concat((CharSequence)new AsciiString((CharSequence)entry.getKey())).concat((CharSequence)HEADER_DELIMITER).concat((CharSequence)entry.getValue()).concat((CharSequence)CRLF);
            }
            return allocator.directBuffer(s.length()).writeBytes(s.toByteArray());
        }
    }
}

