/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import io.netty.channel.ChannelHandler;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.util._ProxyContext;

public final class ProxyContext
extends _ProxyContext {
    @Nullable
    private final String host;
    private final Optional<ChannelHandler> httpProxyHandler;
    @Nullable
    private final String password;
    @Nullable
    private final Integer port;
    @Nullable
    private final String username;

    private ProxyContext(Builder builder) {
        this.host = builder.host;
        this.password = builder.password;
        this.port = builder.port;
        this.username = builder.username;
        this.httpProxyHandler = Objects.requireNonNull(super.getHttpProxyHandler(), "httpProxyHandler");
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    public Optional<ChannelHandler> getHttpProxyHandler() {
        return this.httpProxyHandler;
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Override
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ProxyContext && this.equalTo((ProxyContext)another);
    }

    private boolean equalTo(ProxyContext another) {
        return Objects.equals(this.host, another.host) && this.httpProxyHandler.equals(another.httpProxyHandler) && Objects.equals(this.password, another.password) && Objects.equals(this.port, another.port) && Objects.equals(this.username, another.username);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.host);
        h = h * 17 + this.httpProxyHandler.hashCode();
        h = h * 17 + Objects.hashCode(this.password);
        h = h * 17 + Objects.hashCode(this.port);
        h = h * 17 + Objects.hashCode(this.username);
        return h;
    }

    public String toString() {
        return "ProxyContext{host=" + this.host + ", httpProxyHandler=" + this.httpProxyHandler + ", password=" + this.password + ", port=" + this.port + ", username=" + this.username + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String host;
        private String password;
        private Integer port;
        private String username;

        private Builder() {
        }

        public final Builder from(ProxyContext instance) {
            return this.from((_ProxyContext)instance);
        }

        final Builder from(_ProxyContext instance) {
            String usernameValue;
            Integer portValue;
            String passwordValue;
            Objects.requireNonNull(instance, "instance");
            String hostValue = instance.getHost();
            if (hostValue != null) {
                this.host(hostValue);
            }
            if ((passwordValue = instance.getPassword()) != null) {
                this.password(passwordValue);
            }
            if ((portValue = instance.getPort()) != null) {
                this.port(portValue);
            }
            if ((usernameValue = instance.getUsername()) != null) {
                this.username(usernameValue);
            }
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public final Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        public ProxyContext build() {
            return new ProxyContext(this);
        }
    }
}

