/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.reactor.util.ConnectionContext;
import org.cloudfoundry.reactor.util.DefaultSslCertificateTruster;
import org.cloudfoundry.reactor.util.JsonCodec;
import org.cloudfoundry.reactor.util.ProxyContext;
import org.cloudfoundry.reactor.util.SslCertificateTruster;
import org.cloudfoundry.reactor.util.StaticTrustManagerFactory;
import org.immutables.value.Value;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.config.ClientOptions;
import reactor.io.netty.config.HttpClientOptions;
import reactor.io.netty.http.HttpClient;

@Value.Immutable
abstract class _DefaultConnectionContext
implements ConnectionContext {
    private static final int DEFAULT_PORT = 443;
    private static final int RECEIVE_BUFFER_SIZE = 0xA00000;
    private static final int SEND_BUFFER_SIZE = 0xA00000;
    private static final int UNDEFINED_PORT = -1;

    _DefaultConnectionContext() {
    }

    @Override
    public abstract AuthorizationProvider getAuthorizationProvider();

    @Override
    @Value.Default
    public String getClientId() {
        return "cf";
    }

    @Override
    @Value.Default
    public String getClientSecret() {
        return "";
    }

    @Override
    @Value.Derived
    public HttpClient getHttpClient() {
        return HttpClient.create((ClientOptions)((ClientOptions)((ClientOptions)((ClientOptions)((ClientOptions)HttpClientOptions.create().sslSupport().sndbuf(0xA00000)).rcvbuf(0xA00000)).pipelineConfigurer(pipeline -> this.getProxyContext().getHttpProxyHandler().ifPresent(handler -> pipeline.addBefore("sslHandler", null, handler)))).sslConfigurer(ssl -> this.getSslCertificateTruster().ifPresent(trustManager -> ssl.trustManager((TrustManagerFactory)((Object)new StaticTrustManagerFactory((TrustManager)trustManager)))))));
    }

    @Override
    @Value.Default
    public ObjectMapper getObjectMapper() {
        return new ObjectMapper();
    }

    @Override
    @Value.Derived
    public Mono<String> getRoot() {
        Integer port = this.getPort();
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance().scheme("https").host(this.getHost());
        if (port != null) {
            builder.port(port.intValue());
        }
        UriComponents components = _DefaultConnectionContext.normalize(builder);
        _DefaultConnectionContext.trust(components, this.getSslCertificateTruster());
        return Mono.just((Object)components.toUriString());
    }

    @Override
    public Mono<String> getRoot(String key) {
        return this.getInfo().map(info -> _DefaultConnectionContext.normalize(UriComponentsBuilder.fromUriString((String)((String)info.get(key))))).doOnSuccess(components -> _DefaultConnectionContext.trust(components, this.getSslCertificateTruster())).map(UriComponents::toUriString).cache();
    }

    abstract String getHost();

    @Value.Derived
    Mono<Map<String, String>> getInfo() {
        return this.getRoot().map(uri -> UriComponentsBuilder.fromUriString((String)uri).pathSegment(new String[]{"v2", "info"}).build().toUriString()).then(arg_0 -> ((HttpClient)this.getHttpClient()).get(arg_0)).then(inbound -> inbound.receive().aggregate().toInputStream()).map(JsonCodec.decode(this.getObjectMapper(), Map.class)).map(m -> m).cache();
    }

    @Nullable
    abstract Integer getPort();

    @Value.Derived
    ProxyContext getProxyContext() {
        return ProxyContext.builder().host(this.getProxyHost()).password(this.getProxyPassword()).port(this.getProxyPort()).username(this.getProxyUsername()).build();
    }

    @Nullable
    abstract String getProxyHost();

    @Nullable
    abstract String getProxyPassword();

    @Nullable
    abstract Integer getProxyPort();

    @Nullable
    abstract String getProxyUsername();

    @Value.Derived
    Optional<SslCertificateTruster> getSslCertificateTruster() {
        if (Optional.ofNullable(this.getTrustCertificates()).orElse(false).booleanValue()) {
            return Optional.of(new DefaultSslCertificateTruster(this.getProxyContext()));
        }
        return Optional.empty();
    }

    @Nullable
    abstract Boolean getTrustCertificates();

    private static UriComponents normalize(UriComponentsBuilder builder) {
        UriComponents components = builder.build();
        builder.scheme("https");
        if (-1 == components.getPort()) {
            builder.port(443);
        }
        return builder.build().encode();
    }

    private static void trust(UriComponents components, Optional<SslCertificateTruster> sslCertificateTruster) {
        sslCertificateTruster.ifPresent(t -> t.trust(components.getHost(), components.getPort(), Duration.ofSeconds(30L)));
    }
}

