/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import io.netty.channel.ChannelHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import org.cloudfoundry.Nullable;
import org.immutables.value.Value;
import org.springframework.util.StringUtils;

@Value.Immutable
abstract class _ProxyContext {
    _ProxyContext() {
    }

    @Nullable
    abstract String getHost();

    @Value.Derived
    Optional<ChannelHandler> getHttpProxyHandler() {
        if (StringUtils.hasText((String)this.getHost())) {
            InetSocketAddress proxyAddress = new InetSocketAddress(this.getHost(), (int)Optional.ofNullable(this.getPort()).orElse(8080));
            HttpProxyHandler httpProxyHandler = this.getUsername() != null ? new HttpProxyHandler((SocketAddress)proxyAddress, this.getUsername(), this.getPassword()) : new HttpProxyHandler((SocketAddress)proxyAddress);
            return Optional.of(httpProxyHandler);
        }
        return Optional.empty();
    }

    @Nullable
    abstract String getPassword();

    @Nullable
    abstract Integer getPort();

    @Nullable
    abstract String getUsername();
}

