/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.spring.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.applications.ApplicationsV2;
import org.cloudfoundry.client.v2.applicationusageevents.ApplicationUsageEvents;
import org.cloudfoundry.client.v2.buildpacks.Buildpacks;
import org.cloudfoundry.client.v2.domains.Domains;
import org.cloudfoundry.client.v2.environmentvariablegroups.EnvironmentVariableGroups;
import org.cloudfoundry.client.v2.events.Events;
import org.cloudfoundry.client.v2.featureflags.FeatureFlags;
import org.cloudfoundry.client.v2.info.Info;
import org.cloudfoundry.client.v2.jobs.Jobs;
import org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitions;
import org.cloudfoundry.client.v2.organizations.Organizations;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomains;
import org.cloudfoundry.client.v2.routemappings.RouteMappings;
import org.cloudfoundry.client.v2.routes.Routes;
import org.cloudfoundry.client.v2.securitygroups.SecurityGroups;
import org.cloudfoundry.client.v2.servicebindings.ServiceBindingsV2;
import org.cloudfoundry.client.v2.servicebrokers.ServiceBrokers;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstances;
import org.cloudfoundry.client.v2.servicekeys.ServiceKeys;
import org.cloudfoundry.client.v2.serviceplans.ServicePlans;
import org.cloudfoundry.client.v2.serviceplanvisibilities.ServicePlanVisibilities;
import org.cloudfoundry.client.v2.services.Services;
import org.cloudfoundry.client.v2.serviceusageevents.ServiceUsageEvents;
import org.cloudfoundry.client.v2.shareddomains.SharedDomains;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitions;
import org.cloudfoundry.client.v2.spaces.Spaces;
import org.cloudfoundry.client.v2.stacks.Stacks;
import org.cloudfoundry.client.v2.userprovidedserviceinstances.UserProvidedServiceInstances;
import org.cloudfoundry.client.v2.users.Users;
import org.cloudfoundry.client.v3.applications.ApplicationsV3;
import org.cloudfoundry.client.v3.droplets.Droplets;
import org.cloudfoundry.client.v3.packages.Packages;
import org.cloudfoundry.client.v3.processes.Processes;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingsV3;
import org.cloudfoundry.client.v3.tasks.Tasks;
import org.cloudfoundry.reactor.client.v2.applications.ReactorApplicationsV2;
import org.cloudfoundry.reactor.client.v2.applicationusageevents.ReactorApplicationUsageEvents;
import org.cloudfoundry.reactor.client.v2.buildpacks.ReactorBuildpacks;
import org.cloudfoundry.reactor.client.v2.domains.ReactorDomains;
import org.cloudfoundry.reactor.client.v2.environmentvariablegroups.ReactorEnvironmentVariableGroups;
import org.cloudfoundry.reactor.client.v2.events.ReactorEvents;
import org.cloudfoundry.reactor.client.v2.featureflags.ReactorFeatureFlags;
import org.cloudfoundry.reactor.client.v2.info.ReactorInfo;
import org.cloudfoundry.reactor.client.v2.jobs.ReactorJobs;
import org.cloudfoundry.reactor.client.v2.organizationquotadefinitions.ReactorOrganizationQuotaDefinitions;
import org.cloudfoundry.reactor.client.v2.organizations.ReactorOrganizations;
import org.cloudfoundry.reactor.client.v2.privatedomains.ReactorPrivateDomains;
import org.cloudfoundry.reactor.client.v2.routemappings.ReactorRouteMappings;
import org.cloudfoundry.reactor.client.v2.routes.ReactorRoutes;
import org.cloudfoundry.reactor.client.v2.securitygroups.ReactorSecurityGroups;
import org.cloudfoundry.reactor.client.v2.servicebindings.ReactorServiceBindingsV2;
import org.cloudfoundry.reactor.client.v2.servicebrokers.ReactorServiceBrokers;
import org.cloudfoundry.reactor.client.v2.serviceinstances.ReactorServiceInstances;
import org.cloudfoundry.reactor.client.v2.servicekeys.ReactorServiceKeys;
import org.cloudfoundry.reactor.client.v2.serviceplans.ReactorServicePlans;
import org.cloudfoundry.reactor.client.v2.serviceplanvisibilities.ReactorServicePlanVisibilities;
import org.cloudfoundry.reactor.client.v2.services.ReactorServices;
import org.cloudfoundry.reactor.client.v2.serviceusageevents.ReactorServiceUsageEvents;
import org.cloudfoundry.reactor.client.v2.shareddomains.ReactorSharedDomains;
import org.cloudfoundry.reactor.client.v2.spacequotadefinitions.ReactorSpaceQuotaDefinitions;
import org.cloudfoundry.reactor.client.v2.spaces.ReactorSpaces;
import org.cloudfoundry.reactor.client.v2.stacks.ReactorStacks;
import org.cloudfoundry.reactor.client.v2.userprovidedserviceinstances.ReactorUserProvidedServiceInstances;
import org.cloudfoundry.reactor.client.v2.users.ReactorUsers;
import org.cloudfoundry.reactor.client.v3.applications.ReactorApplicationsV3;
import org.cloudfoundry.reactor.client.v3.droplets.ReactorDroplets;
import org.cloudfoundry.reactor.client.v3.packages.ReactorPackages;
import org.cloudfoundry.reactor.client.v3.processes.ReactorProcesses;
import org.cloudfoundry.reactor.client.v3.servicebindings.ReactorServiceBindingsV3;
import org.cloudfoundry.reactor.client.v3.tasks.ReactorTasks;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.reactor.util.ConnectionContextSupplier;
import org.cloudfoundry.reactor.util.DefaultConnectionContext;
import org.cloudfoundry.spring.util.CloudFoundryClientCompatibilityChecker;
import org.cloudfoundry.spring.util.network.ConnectionContext;
import org.cloudfoundry.spring.util.network.ConnectionContextFactory;
import org.cloudfoundry.spring.util.network.FallbackHttpMessageConverter;
import org.cloudfoundry.spring.util.network.OAuth2RestOperationsOAuth2TokenProvider;
import org.cloudfoundry.spring.util.network.OAuth2RestTemplateBuilder;
import org.cloudfoundry.spring.util.network.OAuth2TokenProvider;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class SpringCloudFoundryClient
implements CloudFoundryClient,
ConnectionContextSupplier {
    private final ApplicationUsageEvents applicationUsageEvents;
    private final ApplicationsV2 applicationsV2;
    private final ApplicationsV3 applicationsV3;
    private final Buildpacks buildpacks;
    private final org.cloudfoundry.reactor.util.ConnectionContext connectionContext;
    private final Domains domains;
    private final Droplets droplets;
    private final EnvironmentVariableGroups environmentVariableGroups;
    private final Events events;
    private final FeatureFlags featureFlags;
    private final Info info;
    private final Jobs jobs;
    private final OrganizationQuotaDefinitions organizationQuotaDefinitions;
    private final Organizations organizations;
    private final Packages packages;
    private final PrivateDomains privateDomains;
    private final Processes processes;
    private final RouteMappings routeMappings;
    private final Routes routes;
    private final SecurityGroups securityGroups;
    private final ServiceBindingsV2 serviceBindingsV2;
    private final ServiceBindingsV3 serviceBindingsV3;
    private final ServiceBrokers serviceBrokers;
    private final ServiceInstances serviceInstances;
    private final ServiceKeys serviceKeys;
    private final ServicePlanVisibilities servicePlanVisibilities;
    private final ServicePlans servicePlans;
    private final ServiceUsageEvents serviceUsageEvents;
    private final Services services;
    private final SharedDomains sharedDomains;
    private final SpaceQuotaDefinitions spaceQuotaDefinitions;
    private final Spaces spaces;
    private final Stacks stacks;
    private final Tasks tasks;
    private final OAuth2TokenProvider tokenProvider;
    private final UserProvidedServiceInstances userProvidedServiceInstances;
    private final Users users;

    SpringCloudFoundryClient(@NonNull String host, Integer port, Boolean skipSslValidation, String clientId, String clientSecret, String proxyHost, String proxyPassword, Integer proxyPort, String proxyUsername, @NonNull String username, @NonNull String password, List<DeserializationProblemHandler> problemHandlers) {
        this(SpringCloudFoundryClient.getConnectionContext(host, port, skipSslValidation, clientId, clientSecret, username, password), host, port, proxyHost, proxyPassword, proxyPort, proxyUsername, skipSslValidation, problemHandlers, clientId, clientSecret);
        if (host == null) {
            throw new NullPointerException("host");
        }
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        new CloudFoundryClientCompatibilityChecker(this.info).check();
    }

    SpringCloudFoundryClient(String host, Integer port, String proxyHost, String proxyPassword, Integer proxyPort, String proxyUsername, Boolean skipSslValidation, OAuth2TokenProvider tokenProvider, List<DeserializationProblemHandler> problemHandlers, String clientId, String clientSecret) {
        this.tokenProvider = tokenProvider;
        ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        problemHandlers.forEach(arg_0 -> ((ObjectMapper)objectMapper).addHandler(arg_0));
        DefaultConnectionContext.Builder connectionContextBuilder = DefaultConnectionContext.builder().authorizationProvider(outbound -> tokenProvider.getToken().map(token -> String.format("bearer %s", token)).map(token -> {
            outbound.addHeader((CharSequence)"Authorization", (CharSequence)token);
            return outbound;
        })).host(host).objectMapper(objectMapper).port(port).proxyHost(proxyHost).proxyPassword(proxyPassword).proxyPort(proxyPort).proxyUsername(proxyUsername).trustCertificates(skipSslValidation);
        Optional.ofNullable(clientId).ifPresent(connectionContextBuilder::clientId);
        Optional.ofNullable(clientSecret).ifPresent(connectionContextBuilder::clientSecret);
        this.connectionContext = connectionContextBuilder.build();
        AuthorizationProvider authorizationProvider = this.connectionContext.getAuthorizationProvider();
        HttpClient httpClient = this.connectionContext.getHttpClient();
        Mono<String> root2 = this.connectionContext.getRoot();
        this.applicationsV2 = new ReactorApplicationsV2(authorizationProvider, httpClient, objectMapper, root2);
        this.applicationsV3 = new ReactorApplicationsV3(authorizationProvider, httpClient, objectMapper, root2);
        this.applicationUsageEvents = new ReactorApplicationUsageEvents(authorizationProvider, httpClient, objectMapper, root2);
        this.buildpacks = new ReactorBuildpacks(authorizationProvider, httpClient, objectMapper, root2);
        this.domains = new ReactorDomains(authorizationProvider, httpClient, objectMapper, root2);
        this.droplets = new ReactorDroplets(authorizationProvider, httpClient, objectMapper, root2);
        this.environmentVariableGroups = new ReactorEnvironmentVariableGroups(authorizationProvider, httpClient, objectMapper, root2);
        this.featureFlags = new ReactorFeatureFlags(authorizationProvider, httpClient, objectMapper, root2);
        this.events = new ReactorEvents(authorizationProvider, httpClient, objectMapper, root2);
        this.info = new ReactorInfo(authorizationProvider, httpClient, objectMapper, root2);
        this.jobs = new ReactorJobs(authorizationProvider, httpClient, objectMapper, root2);
        this.organizationQuotaDefinitions = new ReactorOrganizationQuotaDefinitions(authorizationProvider, httpClient, objectMapper, root2);
        this.organizations = new ReactorOrganizations(authorizationProvider, httpClient, objectMapper, root2);
        this.packages = new ReactorPackages(authorizationProvider, httpClient, objectMapper, root2);
        this.privateDomains = new ReactorPrivateDomains(authorizationProvider, httpClient, objectMapper, root2);
        this.processes = new ReactorProcesses(authorizationProvider, httpClient, objectMapper, root2);
        this.routeMappings = new ReactorRouteMappings(authorizationProvider, httpClient, objectMapper, root2);
        this.routes = new ReactorRoutes(authorizationProvider, httpClient, objectMapper, root2);
        this.securityGroups = new ReactorSecurityGroups(authorizationProvider, httpClient, objectMapper, root2);
        this.serviceBindingsV2 = new ReactorServiceBindingsV2(authorizationProvider, httpClient, objectMapper, root2);
        this.serviceBindingsV3 = new ReactorServiceBindingsV3(authorizationProvider, httpClient, objectMapper, root2);
        this.serviceBrokers = new ReactorServiceBrokers(authorizationProvider, httpClient, objectMapper, root2);
        this.serviceInstances = new ReactorServiceInstances(authorizationProvider, httpClient, objectMapper, root2);
        this.serviceKeys = new ReactorServiceKeys(authorizationProvider, httpClient, objectMapper, root2);
        this.servicePlans = new ReactorServicePlans(authorizationProvider, httpClient, objectMapper, root2);
        this.servicePlanVisibilities = new ReactorServicePlanVisibilities(authorizationProvider, httpClient, objectMapper, root2);
        this.services = new ReactorServices(authorizationProvider, httpClient, objectMapper, root2);
        this.serviceUsageEvents = new ReactorServiceUsageEvents(authorizationProvider, httpClient, objectMapper, root2);
        this.sharedDomains = new ReactorSharedDomains(authorizationProvider, httpClient, objectMapper, root2);
        this.spaceQuotaDefinitions = new ReactorSpaceQuotaDefinitions(authorizationProvider, httpClient, objectMapper, root2);
        this.spaces = new ReactorSpaces(authorizationProvider, httpClient, objectMapper, root2);
        this.stacks = new ReactorStacks(authorizationProvider, httpClient, objectMapper, root2);
        this.tasks = new ReactorTasks(authorizationProvider, httpClient, objectMapper, root2);
        this.users = new ReactorUsers(authorizationProvider, httpClient, objectMapper, root2);
        this.userProvidedServiceInstances = new ReactorUserProvidedServiceInstances(authorizationProvider, httpClient, objectMapper, root2);
    }

    private SpringCloudFoundryClient(ConnectionContext connectionContext, String host, Integer port, String proxyHost, String proxyPassword, Integer proxyPort, String proxyUsername, Boolean skipSslValidation, List<DeserializationProblemHandler> problemHandlers, String clientId, String clientSecret) {
        this(host, port, proxyHost, proxyPassword, proxyPort, proxyUsername, skipSslValidation, SpringCloudFoundryClient.getRestOperations(connectionContext, problemHandlers), problemHandlers, clientId, clientSecret);
    }

    private SpringCloudFoundryClient(String host, Integer port, String proxyHost, String proxyPassword, Integer proxyPort, String proxyUsername, Boolean skipSslValidation, OAuth2RestOperations restOperations, List<DeserializationProblemHandler> problemHandlers, String clientId, String clientSecret) {
        this(host, port, proxyHost, proxyPassword, proxyPort, proxyUsername, skipSslValidation, new OAuth2RestOperationsOAuth2TokenProvider(restOperations), problemHandlers, clientId, clientSecret);
    }

    public ApplicationUsageEvents applicationUsageEvents() {
        return this.applicationUsageEvents;
    }

    public ApplicationsV2 applicationsV2() {
        return this.applicationsV2;
    }

    public ApplicationsV3 applicationsV3() {
        return this.applicationsV3;
    }

    public Buildpacks buildpacks() {
        return this.buildpacks;
    }

    public Domains domains() {
        return this.domains;
    }

    public Droplets droplets() {
        return this.droplets;
    }

    public EnvironmentVariableGroups environmentVariableGroups() {
        return this.environmentVariableGroups;
    }

    public Events events() {
        return this.events;
    }

    public FeatureFlags featureFlags() {
        return this.featureFlags;
    }

    public Mono<String> getAccessToken() {
        return this.tokenProvider.getToken();
    }

    @Override
    public org.cloudfoundry.reactor.util.ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Info info() {
        return this.info;
    }

    public Jobs jobs() {
        return this.jobs;
    }

    public OrganizationQuotaDefinitions organizationQuotaDefinitions() {
        return this.organizationQuotaDefinitions;
    }

    public Organizations organizations() {
        return this.organizations;
    }

    public Packages packages() {
        return this.packages;
    }

    public PrivateDomains privateDomains() {
        return this.privateDomains;
    }

    public Processes processes() {
        return this.processes;
    }

    public RouteMappings routeMappings() {
        return this.routeMappings;
    }

    public Routes routes() {
        return this.routes;
    }

    public SecurityGroups securityGroups() {
        return this.securityGroups;
    }

    public ServiceBindingsV2 serviceBindingsV2() {
        return this.serviceBindingsV2;
    }

    public ServiceBindingsV3 serviceBindingsV3() {
        return this.serviceBindingsV3;
    }

    public ServiceBrokers serviceBrokers() {
        return this.serviceBrokers;
    }

    public ServiceInstances serviceInstances() {
        return this.serviceInstances;
    }

    public ServiceKeys serviceKeys() {
        return this.serviceKeys;
    }

    public ServicePlanVisibilities servicePlanVisibilities() {
        return this.servicePlanVisibilities;
    }

    public ServicePlans servicePlans() {
        return this.servicePlans;
    }

    public ServiceUsageEvents serviceUsageEvents() {
        return this.serviceUsageEvents;
    }

    public Services services() {
        return this.services;
    }

    public SharedDomains sharedDomains() {
        return this.sharedDomains;
    }

    public SpaceQuotaDefinitions spaceQuotaDefinitions() {
        return this.spaceQuotaDefinitions;
    }

    public Spaces spaces() {
        return this.spaces;
    }

    public Stacks stacks() {
        return this.stacks;
    }

    public Tasks tasks() {
        return this.tasks;
    }

    public UserProvidedServiceInstances userProvidedServiceInstances() {
        return this.userProvidedServiceInstances;
    }

    public Users users() {
        return this.users;
    }

    private static ConnectionContext getConnectionContext(String host, Integer port, Boolean skipSslValidation, String clientId, String clientSecret, String username, String password) {
        return new ConnectionContextFactory().trustCertificates(skipSslValidation).host(host).port(port).clientId(clientId).clientSecret(clientSecret).username(username).password(password).build();
    }

    private static OAuth2RestOperations getRestOperations(ConnectionContext connectionContext, List<DeserializationProblemHandler> problemHandlers) {
        return new OAuth2RestTemplateBuilder().clientContext(connectionContext.getClientContext()).protectedResourceDetails(connectionContext.getProtectedResourceDetails()).hostnameVerifier(connectionContext.getHostnameVerifier()).sslContext(connectionContext.getSslContext()).messageConverter((HttpMessageConverter<?>)new FallbackHttpMessageConverter()).problemHandlers(problemHandlers).build();
    }

    public static SpringCloudFoundryClientBuilder builder() {
        return new SpringCloudFoundryClientBuilder();
    }

    public static class SpringCloudFoundryClientBuilder {
        private String host;
        private Integer port;
        private Boolean skipSslValidation;
        private String clientId;
        private String clientSecret;
        private String proxyHost;
        private String proxyPassword;
        private Integer proxyPort;
        private String proxyUsername;
        private String username;
        private String password;
        private ArrayList<DeserializationProblemHandler> problemHandlers;

        SpringCloudFoundryClientBuilder() {
        }

        public SpringCloudFoundryClientBuilder host(String host) {
            this.host = host;
            return this;
        }

        public SpringCloudFoundryClientBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public SpringCloudFoundryClientBuilder skipSslValidation(Boolean skipSslValidation) {
            this.skipSslValidation = skipSslValidation;
            return this;
        }

        public SpringCloudFoundryClientBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public SpringCloudFoundryClientBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public SpringCloudFoundryClientBuilder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public SpringCloudFoundryClientBuilder proxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public SpringCloudFoundryClientBuilder proxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public SpringCloudFoundryClientBuilder proxyUsername(String proxyUsername) {
            this.proxyUsername = proxyUsername;
            return this;
        }

        public SpringCloudFoundryClientBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SpringCloudFoundryClientBuilder password(String password) {
            this.password = password;
            return this;
        }

        public SpringCloudFoundryClientBuilder problemHandler(DeserializationProblemHandler problemHandler) {
            if (this.problemHandlers == null) {
                this.problemHandlers = new ArrayList();
            }
            this.problemHandlers.add(problemHandler);
            return this;
        }

        public SpringCloudFoundryClientBuilder problemHandlers(Collection<? extends DeserializationProblemHandler> problemHandlers) {
            if (this.problemHandlers == null) {
                this.problemHandlers = new ArrayList();
            }
            this.problemHandlers.addAll(problemHandlers);
            return this;
        }

        public SpringCloudFoundryClientBuilder clearProblemHandlers() {
            if (this.problemHandlers != null) {
                this.problemHandlers.clear();
            }
            return this;
        }

        public SpringCloudFoundryClient build() {
            List<DeserializationProblemHandler> problemHandlers;
            switch (this.problemHandlers == null ? 0 : this.problemHandlers.size()) {
                case 0: {
                    problemHandlers = Collections.emptyList();
                    break;
                }
                case 1: {
                    problemHandlers = Collections.singletonList(this.problemHandlers.get(0));
                    break;
                }
                default: {
                    problemHandlers = Collections.unmodifiableList(new ArrayList<DeserializationProblemHandler>(this.problemHandlers));
                }
            }
            return new SpringCloudFoundryClient(this.host, this.port, this.skipSslValidation, this.clientId, this.clientSecret, this.proxyHost, this.proxyPassword, this.proxyPort, this.proxyUsername, this.username, this.password, problemHandlers);
        }

        public String toString() {
            return "SpringCloudFoundryClient.SpringCloudFoundryClientBuilder(host=" + this.host + ", port=" + this.port + ", skipSslValidation=" + this.skipSslValidation + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", proxyHost=" + this.proxyHost + ", proxyPassword=" + this.proxyPassword + ", proxyPort=" + this.proxyPort + ", proxyUsername=" + this.proxyUsername + ", username=" + this.username + ", password=" + this.password + ", problemHandlers=" + this.problemHandlers + ")";
        }
    }
}

