/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.spring.util;

import com.github.zafarkhaja.semver.Version;
import org.cloudfoundry.client.v2.info.GetInfoRequest;
import org.cloudfoundry.client.v2.info.Info;
import org.cloudfoundry.spring.util.CompatibilityChecker;
import org.cloudfoundry.util.tuple.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public final class CloudFoundryClientCompatibilityChecker
implements CompatibilityChecker {
    private final Logger logger = LoggerFactory.getLogger((String)"cloudfoundry-client.compatibility");
    private final Info info;

    public CloudFoundryClientCompatibilityChecker(Info info) {
        this.info = info;
    }

    @Override
    public void check() {
        this.info.get(GetInfoRequest.builder().build()).map(response -> Version.valueOf((String)response.getApiVersion())).and(Mono.just((Object)Version.valueOf((String)"2.54.0"))).doOnSuccess(TupleUtils.consumer((server, supported) -> CloudFoundryClientCompatibilityChecker.logCompatibility(server, supported, this.logger))).subscribe();
    }

    private static void logCompatibility(Version server, Version supported, Logger logger) {
        String message = "Client supports API version {} and is connected to server with API version {}. Things may not work as expected.";
        if (server.greaterThan(supported)) {
            logger.info(message, (Object)supported, (Object)server);
        } else if (server.lessThan(supported)) {
            logger.warn(message, (Object)supported, (Object)server);
        }
    }
}

