/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.spring.util.network;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.cloudfoundry.spring.util.network.SslCertificateTruster;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

final class AccessTokenUriBuilder {
    private String host;
    private Integer port;
    private RestOperations restOperations;
    private SslCertificateTruster sslCertificateTruster;

    AccessTokenUriBuilder() {
    }

    public URI build() {
        Map info = (Map)this.restOperations.getForObject(AccessTokenUriBuilder.getInfoUri(this.host, this.port, this.sslCertificateTruster), Map.class);
        return AccessTokenUriBuilder.getAccessTokenUri((String)info.get("token_endpoint"), this.sslCertificateTruster);
    }

    private static URI getAccessTokenUri(String tokenEndpoint, SslCertificateTruster sslCertificateTruster) {
        URI uri = UriComponentsBuilder.fromUriString((String)tokenEndpoint).pathSegment(new String[]{"oauth", "token"}).build().toUri();
        sslCertificateTruster.trust(uri.getHost(), uri.getPort(), 5, TimeUnit.SECONDS);
        return uri;
    }

    private static URI getInfoUri(String host, Integer port, SslCertificateTruster sslCertificateTruster) {
        URI uri = UriComponentsBuilder.newInstance().scheme("https").host(host).port(Optional.ofNullable(port).orElse(443).intValue()).pathSegment(new String[]{"v2", "info"}).build().toUri();
        sslCertificateTruster.trust(uri.getHost(), uri.getPort(), 5, TimeUnit.SECONDS);
        return uri;
    }

    public AccessTokenUriBuilder host(String host) {
        this.host = host;
        return this;
    }

    public AccessTokenUriBuilder port(Integer port) {
        this.port = port;
        return this;
    }

    public AccessTokenUriBuilder restOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
        return this;
    }

    public AccessTokenUriBuilder sslCertificateTruster(SslCertificateTruster sslCertificateTruster) {
        this.sslCertificateTruster = sslCertificateTruster;
        return this;
    }

    public String toString() {
        return "AccessTokenUriBuilder(host=" + this.host + ", port=" + this.port + ", restOperations=" + this.restOperations + ", sslCertificateTruster=" + this.sslCertificateTruster + ")";
    }
}

