/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.spring.util.network;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.spring.util.network.SslCertificateTruster;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;

public final class ConnectionContext {
    private final OAuth2ClientContext clientContext;
    private final CloudFoundryClient cloudFoundryClient;
    private final HostnameVerifier hostnameVerifier;
    private final OAuth2ProtectedResourceDetails protectedResourceDetails;
    private final SslCertificateTruster sslCertificateTruster;
    private final SSLContext sslContext;

    ConnectionContext(OAuth2ClientContext clientContext, CloudFoundryClient cloudFoundryClient, HostnameVerifier hostnameVerifier, OAuth2ProtectedResourceDetails protectedResourceDetails, SslCertificateTruster sslCertificateTruster, SSLContext sslContext) {
        this.clientContext = clientContext;
        this.cloudFoundryClient = cloudFoundryClient;
        this.hostnameVerifier = hostnameVerifier;
        this.protectedResourceDetails = protectedResourceDetails;
        this.sslCertificateTruster = sslCertificateTruster;
        this.sslContext = sslContext;
    }

    public static ConnectionContextBuilder builder() {
        return new ConnectionContextBuilder();
    }

    public ConnectionContextBuilder toBuilder() {
        return new ConnectionContextBuilder().clientContext(this.clientContext).cloudFoundryClient(this.cloudFoundryClient).hostnameVerifier(this.hostnameVerifier).protectedResourceDetails(this.protectedResourceDetails).sslCertificateTruster(this.sslCertificateTruster).sslContext(this.sslContext);
    }

    public OAuth2ClientContext getClientContext() {
        return this.clientContext;
    }

    public CloudFoundryClient getCloudFoundryClient() {
        return this.cloudFoundryClient;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public OAuth2ProtectedResourceDetails getProtectedResourceDetails() {
        return this.protectedResourceDetails;
    }

    public SslCertificateTruster getSslCertificateTruster() {
        return this.sslCertificateTruster;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionContext)) {
            return false;
        }
        ConnectionContext other = (ConnectionContext)o;
        OAuth2ClientContext this$clientContext = this.getClientContext();
        OAuth2ClientContext other$clientContext = other.getClientContext();
        if (this$clientContext == null ? other$clientContext != null : !this$clientContext.equals(other$clientContext)) {
            return false;
        }
        CloudFoundryClient this$cloudFoundryClient = this.getCloudFoundryClient();
        CloudFoundryClient other$cloudFoundryClient = other.getCloudFoundryClient();
        if (this$cloudFoundryClient == null ? other$cloudFoundryClient != null : !this$cloudFoundryClient.equals(other$cloudFoundryClient)) {
            return false;
        }
        HostnameVerifier this$hostnameVerifier = this.getHostnameVerifier();
        HostnameVerifier other$hostnameVerifier = other.getHostnameVerifier();
        if (this$hostnameVerifier == null ? other$hostnameVerifier != null : !this$hostnameVerifier.equals(other$hostnameVerifier)) {
            return false;
        }
        OAuth2ProtectedResourceDetails this$protectedResourceDetails = this.getProtectedResourceDetails();
        OAuth2ProtectedResourceDetails other$protectedResourceDetails = other.getProtectedResourceDetails();
        if (this$protectedResourceDetails == null ? other$protectedResourceDetails != null : !this$protectedResourceDetails.equals(other$protectedResourceDetails)) {
            return false;
        }
        SslCertificateTruster this$sslCertificateTruster = this.getSslCertificateTruster();
        SslCertificateTruster other$sslCertificateTruster = other.getSslCertificateTruster();
        if (this$sslCertificateTruster == null ? other$sslCertificateTruster != null : !this$sslCertificateTruster.equals(other$sslCertificateTruster)) {
            return false;
        }
        SSLContext this$sslContext = this.getSslContext();
        SSLContext other$sslContext = other.getSslContext();
        return !(this$sslContext == null ? other$sslContext != null : !this$sslContext.equals(other$sslContext));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OAuth2ClientContext $clientContext = this.getClientContext();
        result = result * 59 + ($clientContext == null ? 43 : $clientContext.hashCode());
        CloudFoundryClient $cloudFoundryClient = this.getCloudFoundryClient();
        result = result * 59 + ($cloudFoundryClient == null ? 43 : $cloudFoundryClient.hashCode());
        HostnameVerifier $hostnameVerifier = this.getHostnameVerifier();
        result = result * 59 + ($hostnameVerifier == null ? 43 : $hostnameVerifier.hashCode());
        OAuth2ProtectedResourceDetails $protectedResourceDetails = this.getProtectedResourceDetails();
        result = result * 59 + ($protectedResourceDetails == null ? 43 : $protectedResourceDetails.hashCode());
        SslCertificateTruster $sslCertificateTruster = this.getSslCertificateTruster();
        result = result * 59 + ($sslCertificateTruster == null ? 43 : $sslCertificateTruster.hashCode());
        SSLContext $sslContext = this.getSslContext();
        result = result * 59 + ($sslContext == null ? 43 : $sslContext.hashCode());
        return result;
    }

    public String toString() {
        return "ConnectionContext(clientContext=" + this.getClientContext() + ", cloudFoundryClient=" + this.getCloudFoundryClient() + ", hostnameVerifier=" + this.getHostnameVerifier() + ", protectedResourceDetails=" + this.getProtectedResourceDetails() + ", sslCertificateTruster=" + this.getSslCertificateTruster() + ", sslContext=" + this.getSslContext() + ")";
    }

    public static class ConnectionContextBuilder {
        private OAuth2ClientContext clientContext;
        private CloudFoundryClient cloudFoundryClient;
        private HostnameVerifier hostnameVerifier;
        private OAuth2ProtectedResourceDetails protectedResourceDetails;
        private SslCertificateTruster sslCertificateTruster;
        private SSLContext sslContext;

        ConnectionContextBuilder() {
        }

        public ConnectionContextBuilder clientContext(OAuth2ClientContext clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public ConnectionContextBuilder cloudFoundryClient(CloudFoundryClient cloudFoundryClient) {
            this.cloudFoundryClient = cloudFoundryClient;
            return this;
        }

        public ConnectionContextBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public ConnectionContextBuilder protectedResourceDetails(OAuth2ProtectedResourceDetails protectedResourceDetails) {
            this.protectedResourceDetails = protectedResourceDetails;
            return this;
        }

        public ConnectionContextBuilder sslCertificateTruster(SslCertificateTruster sslCertificateTruster) {
            this.sslCertificateTruster = sslCertificateTruster;
            return this;
        }

        public ConnectionContextBuilder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public ConnectionContext build() {
            return new ConnectionContext(this.clientContext, this.cloudFoundryClient, this.hostnameVerifier, this.protectedResourceDetails, this.sslCertificateTruster, this.sslContext);
        }

        public String toString() {
            return "ConnectionContext.ConnectionContextBuilder(clientContext=" + this.clientContext + ", cloudFoundryClient=" + this.cloudFoundryClient + ", hostnameVerifier=" + this.hostnameVerifier + ", protectedResourceDetails=" + this.protectedResourceDetails + ", sslCertificateTruster=" + this.sslCertificateTruster + ", sslContext=" + this.sslContext + ")";
        }
    }
}

