/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.spring.util.network;

import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.cloudfoundry.spring.util.network.AccessTokenUriBuilder;
import org.cloudfoundry.spring.util.network.ConnectionContext;
import org.cloudfoundry.spring.util.network.CustomSslSimpleClientHttpRequestFactory;
import org.cloudfoundry.spring.util.network.DynamicTrustManager;
import org.cloudfoundry.spring.util.network.ResourceOwnerPasswordResourceDetailsBuilder;
import org.cloudfoundry.spring.util.network.SslCertificateTruster;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public final class ConnectionContextFactory {
    private String clientId;
    private String clientSecret;
    private String host;
    private String password;
    private Integer port;
    private RestOperations restOperations;
    private Boolean trustCertificates;
    private String username;

    public ConnectionContext build() {
        DynamicTrustManager dynamicTrustManager = ConnectionContextFactory.getDynamicTrustManager(this.trustCertificates);
        SSLContext sslContext = ConnectionContextFactory.getSslContext(dynamicTrustManager);
        RestOperations restOperations = Optional.ofNullable(this.restOperations).orElse(ConnectionContextFactory.getRestOperations(dynamicTrustManager, sslContext));
        URI accessTokenUri = ConnectionContextFactory.getAccessTokenUri(this.host, this.port, restOperations, dynamicTrustManager);
        return ConnectionContext.builder().clientContext(ConnectionContextFactory.getClientContext()).protectedResourceDetails(ConnectionContextFactory.getProtectedResourceDetails(this.clientId, this.clientSecret, this.username, this.password, accessTokenUri)).sslCertificateTruster(dynamicTrustManager).hostnameVerifier(dynamicTrustManager).sslContext(sslContext).build();
    }

    private static URI getAccessTokenUri(String host, Integer port, RestOperations restOperations, SslCertificateTruster sslCertificateTruster) {
        return new AccessTokenUriBuilder().host(host).port(port).restOperations(restOperations).sslCertificateTruster(sslCertificateTruster).build();
    }

    private static OAuth2ClientContext getClientContext() {
        return new DefaultOAuth2ClientContext((AccessTokenRequest)new DefaultAccessTokenRequest());
    }

    private static DynamicTrustManager getDynamicTrustManager(Boolean trustCertificates) {
        return new DynamicTrustManager(trustCertificates);
    }

    private static OAuth2ProtectedResourceDetails getProtectedResourceDetails(String clientId, String clientSecret, String username, String password, URI accessTokenUri) {
        return new ResourceOwnerPasswordResourceDetailsBuilder().clientId(clientId).clientSecret(clientSecret).accessTokenUri(accessTokenUri).username(username).password(password).build();
    }

    private static RestOperations getRestOperations(HostnameVerifier hostnameVerifier, SSLContext sslContext) {
        return new RestTemplate((ClientHttpRequestFactory)new CustomSslSimpleClientHttpRequestFactory(hostnameVerifier, sslContext));
    }

    private static SSLContext getSslContext(TrustManager trustManager) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectionContextFactory clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public ConnectionContextFactory clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public ConnectionContextFactory host(String host) {
        this.host = host;
        return this;
    }

    public ConnectionContextFactory password(String password) {
        this.password = password;
        return this;
    }

    public ConnectionContextFactory port(Integer port) {
        this.port = port;
        return this;
    }

    public ConnectionContextFactory restOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
        return this;
    }

    public ConnectionContextFactory trustCertificates(Boolean trustCertificates) {
        this.trustCertificates = trustCertificates;
        return this;
    }

    public ConnectionContextFactory username(String username) {
        this.username = username;
        return this;
    }

    public String toString() {
        return "ConnectionContextFactory(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", host=" + this.host + ", password=" + this.password + ", port=" + this.port + ", restOperations=" + this.restOperations + ", trustCertificates=" + this.trustCertificates + ", username=" + this.username + ")";
    }
}

