/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.spring.util.network;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.springframework.http.client.SimpleClientHttpRequestFactory;

final class CustomSslSimpleClientHttpRequestFactory
extends SimpleClientHttpRequestFactory {
    private final HostnameVerifier hostNameVerifier;
    private final SSLContext sslContext;

    public CustomSslSimpleClientHttpRequestFactory(HostnameVerifier hostnameVerifier, SSLContext sslContext) {
        this.hostNameVerifier = hostnameVerifier;
        this.sslContext = sslContext;
    }

    protected HttpURLConnection openConnection(URL url, Proxy proxy) throws IOException {
        HttpURLConnection connection = super.openConnection(url, proxy);
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setSSLSocketFactory(this.sslContext.getSocketFactory());
            httpsConnection.setHostnameVerifier(this.hostNameVerifier);
        }
        return connection;
    }
}

