/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.spring.util.network;

import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.util.UriComponentsBuilder;

final class LoggingClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final Logger logger = LoggerFactory.getLogger((String)"cloudfoundry-client.request");

    LoggingClientHttpRequestInterceptor() {
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(LoggingClientHttpRequestInterceptor.toString(request));
        }
        return execution.execute(request, body);
    }

    private static String toString(HttpRequest request) {
        return String.format("%-6s %s", request.getMethod(), LoggingClientHttpRequestInterceptor.trimUri(request.getURI()));
    }

    private static URI trimUri(URI uri) {
        return UriComponentsBuilder.fromUri((URI)uri).scheme(null).host(null).port(null).build().encode().toUri();
    }
}

