/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.spring.util.network;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.cloudfoundry.spring.util.network.CustomSslSimpleClientHttpRequestFactory;
import org.cloudfoundry.spring.util.network.LoggingClientHttpRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordAccessTokenProvider;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public final class OAuth2RestTemplateBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OAuth2ClientContext clientContext;
    private HostnameVerifier hostnameVerifier;
    private List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private List<DeserializationProblemHandler> problemHandlers = new ArrayList<DeserializationProblemHandler>();
    private OAuth2ProtectedResourceDetails protectedResourceDetails;
    private SSLContext sslContext;

    public OAuth2RestTemplate build() {
        OAuth2RestTemplate restTemplate = OAuth2RestTemplateBuilder.getRestTemplate(this.clientContext, this.protectedResourceDetails);
        OAuth2RestTemplateBuilder.addLogging((RestTemplate)restTemplate);
        OAuth2RestTemplateBuilder.addMessageConverters((RestTemplate)restTemplate, this.messageConverters);
        OAuth2RestTemplateBuilder.modifyObjectMapper(OAuth2RestTemplateBuilder.getObjectMapper((RestTemplate)restTemplate), this.problemHandlers, this.logger);
        OAuth2RestTemplateBuilder.setRequestFactory(restTemplate, this.hostnameVerifier, this.sslContext);
        return restTemplate;
    }

    public OAuth2RestTemplateBuilder messageConverter(HttpMessageConverter<?> messageConverter) {
        this.messageConverters.add(messageConverter);
        return this;
    }

    public OAuth2RestTemplateBuilder problemHandler(DeserializationProblemHandler problemHandler) {
        this.problemHandlers.add(problemHandler);
        return this;
    }

    private static void addLogging(RestTemplate restTemplate) {
        restTemplate.getInterceptors().add(new LoggingClientHttpRequestInterceptor());
    }

    private static void addMessageConverters(RestTemplate restTemplate, List<HttpMessageConverter<?>> httpMessageConverters) {
        for (HttpMessageConverter<?> httpMessageConverter : httpMessageConverters) {
            restTemplate.getMessageConverters().add(httpMessageConverter);
        }
    }

    private static ResourceOwnerPasswordAccessTokenProvider getAccessTokenProvider(ClientHttpRequestFactory requestFactory) {
        ResourceOwnerPasswordAccessTokenProvider accessTokenProvider = new ResourceOwnerPasswordAccessTokenProvider();
        accessTokenProvider.setRequestFactory(requestFactory);
        return accessTokenProvider;
    }

    private static Optional<ObjectMapper> getObjectMapper(RestTemplate restTemplate) {
        for (HttpMessageConverter messageConverter : restTemplate.getMessageConverters()) {
            if (!(messageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
            ObjectMapper objectMapper = ((MappingJackson2HttpMessageConverter)messageConverter).getObjectMapper();
            return Optional.of(objectMapper);
        }
        return Optional.empty();
    }

    private static OAuth2RestTemplate getRestTemplate(OAuth2ClientContext clientContext, OAuth2ProtectedResourceDetails protectedResourceDetails) {
        Assert.notNull((Object)clientContext, (String)"clientContext must not be null");
        Assert.notNull((Object)protectedResourceDetails, (String)"protectedResourceDetails must not be null");
        return new OAuth2RestTemplate(protectedResourceDetails, clientContext);
    }

    private static void modifyObjectMapper(Optional<ObjectMapper> objectMapper, List<DeserializationProblemHandler> problemHandlers, Logger logger) {
        objectMapper.ifPresent(objectMapper1 -> {
            logger.debug("Modifying ObjectMapper configuration");
            objectMapper1.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            problemHandlers.forEach(arg_0 -> ((ObjectMapper)objectMapper1).addHandler(arg_0));
        });
    }

    private static void setRequestFactory(OAuth2RestTemplate restTemplate, HostnameVerifier hostnameVerifier, SSLContext sslContext) {
        if (hostnameVerifier != null && sslContext != null) {
            CustomSslSimpleClientHttpRequestFactory requestFactory = new CustomSslSimpleClientHttpRequestFactory(hostnameVerifier, sslContext);
            restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
            restTemplate.setAccessTokenProvider((AccessTokenProvider)OAuth2RestTemplateBuilder.getAccessTokenProvider((ClientHttpRequestFactory)requestFactory));
        }
    }

    public OAuth2RestTemplateBuilder clientContext(OAuth2ClientContext clientContext) {
        this.clientContext = clientContext;
        return this;
    }

    public OAuth2RestTemplateBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public OAuth2RestTemplateBuilder messageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
        return this;
    }

    public OAuth2RestTemplateBuilder problemHandlers(List<DeserializationProblemHandler> problemHandlers) {
        this.problemHandlers = problemHandlers;
        return this;
    }

    public OAuth2RestTemplateBuilder protectedResourceDetails(OAuth2ProtectedResourceDetails protectedResourceDetails) {
        this.protectedResourceDetails = protectedResourceDetails;
        return this;
    }

    public OAuth2RestTemplateBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public String toString() {
        return "OAuth2RestTemplateBuilder(logger=" + this.logger + ", clientContext=" + this.clientContext + ", hostnameVerifier=" + this.hostnameVerifier + ", messageConverters=" + this.messageConverters + ", problemHandlers=" + this.problemHandlers + ", protectedResourceDetails=" + this.protectedResourceDetails + ", sslContext=" + this.sslContext + ")";
    }
}

