/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.spring.util.network;

import java.net.URI;
import java.util.Optional;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordResourceDetails;

final class ResourceOwnerPasswordResourceDetailsBuilder {
    private URI accessTokenUri;
    private String clientId;
    private String clientSecret;
    private String password;
    private String username;

    ResourceOwnerPasswordResourceDetailsBuilder() {
    }

    public ResourceOwnerPasswordResourceDetails build() {
        ResourceOwnerPasswordResourceDetails details = new ResourceOwnerPasswordResourceDetails();
        details.setAccessTokenUri(this.accessTokenUri.toASCIIString());
        details.setClientId(Optional.ofNullable(this.clientId).orElse("cf"));
        details.setClientSecret(Optional.ofNullable(this.clientSecret).orElse(""));
        details.setUsername(this.username);
        details.setPassword(this.password);
        return details;
    }

    public ResourceOwnerPasswordResourceDetailsBuilder accessTokenUri(URI accessTokenUri) {
        this.accessTokenUri = accessTokenUri;
        return this;
    }

    public ResourceOwnerPasswordResourceDetailsBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public ResourceOwnerPasswordResourceDetailsBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public ResourceOwnerPasswordResourceDetailsBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ResourceOwnerPasswordResourceDetailsBuilder username(String username) {
        this.username = username;
        return this;
    }

    public String toString() {
        return "ResourceOwnerPasswordResourceDetailsBuilder(accessTokenUri=" + this.accessTokenUri + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", password=" + this.password + ", username=" + this.username + ")";
    }
}

