/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.utils;

import java.util.concurrent.TimeUnit;
import org.cloudfoundry.utils.tuple.Function2;
import org.cloudfoundry.utils.tuple.TupleUtils;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.fn.Predicate;
import reactor.fn.tuple.Tuple;
import reactor.rx.Stream;

public final class DelayUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cloudfoundry-client.delay");

    public static Function<Stream<Long>, Publisher<?>> exponentialBackOff(final long minDuration, final long maxDuration, final TimeUnit timeUnit, final int maxRetries) {
        return new Function<Stream<Long>, Publisher<?>>(){

            public Publisher<?> apply(Stream<Long> count) {
                return Flux.zip((Function)Tuple.fn2(), (int)1, (Publisher[])new Publisher[]{DelayUtils.getTest((Stream<Long>)count), DelayUtils.getRetryCounter(maxRetries)}).flatMap(TupleUtils.function(new Function2<Long, Integer, Publisher<?>>(){

                    @Override
                    public Publisher<?> apply(Long itemCount, Integer retryCount) {
                        return DelayUtils.getDelay(minDuration, maxDuration, timeUnit, retryCount);
                    }
                }));
            }
        };
    }

    public static Function<Stream<Long>, Publisher<?>> fixed(final long duration, final TimeUnit timeUnit) {
        return new Function<Stream<Long>, Publisher<?>>(){

            public Publisher<?> apply(Stream<Long> volumes) {
                return volumes.takeWhile((Predicate)new Predicate<Long>(){

                    public boolean test(Long count) {
                        return count == 0L;
                    }
                }).flatMap((Function)new Function<Long, Publisher<Long>>(){

                    public Publisher<Long> apply(Long count) {
                        return Mono.delay((long)duration, (TimeUnit)timeUnit).doOnSubscribe((Consumer)new Consumer<Subscription>(){

                            public void accept(Subscription subscription) {
                                LOGGER.debug("Delaying {} {}", (Object)duration, (Object)timeUnit);
                            }
                        });
                    }
                });
            }
        };
    }

    static long calculateDuration(long minDuration, long maxDuration, Integer retryCount) {
        long candidateDuration = minDuration * (long)Math.pow(2.0, retryCount.intValue());
        return Math.min(candidateDuration, maxDuration);
    }

    static Publisher<?> getDelay(long minDuration, long maxDuration, final TimeUnit timeUnit, Integer retryCount) {
        final long duration = DelayUtils.calculateDuration(minDuration, maxDuration, retryCount);
        return Mono.delay((long)duration, (TimeUnit)timeUnit).doOnSubscribe((Consumer)new Consumer<Subscription>(){

            public void accept(Subscription subscription) {
                LOGGER.debug("Delaying {} {}", (Object)duration, (Object)timeUnit.toString().toLowerCase());
            }
        });
    }

    static Stream<Integer> getRetryCounter(int maxRetries) {
        return Stream.range((int)0, (int)maxRetries).concatWith((Publisher)Stream.error((Throwable)new IllegalStateException("Exceeded maximum number of retries"), (boolean)true));
    }

    private static Stream<Long> getTest(Stream<Long> count) {
        return count.takeWhile((Predicate)new Predicate<Long>(){

            public boolean test(Long count) {
                return count == 0L;
            }
        });
    }
}

