/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.utils;

import java.util.NoSuchElementException;
import reactor.core.publisher.Mono;
import reactor.fn.Function;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static <T> Function<Throwable, Mono<T>> convert(final String format, final Object ... args) {
        return new Function<Throwable, Mono<T>>(){

            public Mono<T> apply(Throwable throwable) {
                if (throwable instanceof NoSuchElementException) {
                    String message = String.format(format, args);
                    return Mono.error((Throwable)new IllegalArgumentException(message, throwable));
                }
                return Mono.error((Throwable)throwable);
            }
        };
    }

    public static <T> Mono<T> illegalState(String format, Object ... args) {
        String message = String.format(format, args);
        return Mono.error((Throwable)new IllegalStateException(message));
    }
}

