/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.utils;

import java.util.concurrent.TimeUnit;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.CloudFoundryException;
import org.cloudfoundry.client.v2.job.GetJobRequest;
import org.cloudfoundry.client.v2.job.GetJobResponse;
import org.cloudfoundry.client.v2.job.JobEntity;
import org.cloudfoundry.utils.DelayUtils;
import org.cloudfoundry.utils.OperationUtils;
import reactor.core.publisher.Mono;
import reactor.fn.Function;
import reactor.fn.Predicate;

public final class JobUtils {
    private JobUtils() {
    }

    public static Mono<Void> waitForCompletion(CloudFoundryClient cloudFoundryClient, String jobId) {
        return ((Mono)JobUtils.requestJob(cloudFoundryClient, jobId).map((Function)new Function<GetJobResponse, JobEntity>(){

            public JobEntity apply(GetJobResponse response) {
                return (JobEntity)response.getEntity();
            }
        }).where((Predicate)new Predicate<JobEntity>(){

            public boolean test(JobEntity entity) {
                return JobUtils.isComplete(entity);
            }
        }).as(OperationUtils.repeatWhen(DelayUtils.exponentialBackOff(1L, 10L, TimeUnit.SECONDS, 10)))).where((Predicate)new Predicate<JobEntity>(){

            public boolean test(JobEntity entity) {
                return "failed".equals(entity.getStatus());
            }
        }).flatMap((Function)new Function<JobEntity, Mono<Void>>(){

            public Mono<Void> apply(JobEntity entity) {
                return JobUtils.getError(entity);
            }
        }).after();
    }

    private static Mono<Void> getError(JobEntity entity) {
        JobEntity.ErrorDetails errorDetails = entity.getErrorDetails();
        return Mono.error((Throwable)new CloudFoundryException(errorDetails.getCode(), errorDetails.getDescription(), errorDetails.getErrorCode()));
    }

    private static boolean isComplete(JobEntity entity) {
        String status = entity.getStatus();
        return "finished".equals(status) || "failed".equals(status);
    }

    private static Mono<GetJobResponse> requestJob(CloudFoundryClient cloudFoundryClient, String jobId) {
        return cloudFoundryClient.jobs().get(GetJobRequest.builder().jobId(jobId).build());
    }
}

