/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.utils;

import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.fn.Function;
import reactor.fn.Predicate;
import reactor.fn.Supplier;
import reactor.rx.Promise;
import reactor.rx.Stream;

public final class OperationUtils {
    private OperationUtils() {
    }

    public static <IN, OUT> Function<Mono<? extends IN>, Mono<OUT>> afterComplete(final Supplier<Mono<OUT>> supplier) {
        return new Function<Mono<? extends IN>, Mono<OUT>>(){

            public Mono<OUT> apply(Mono<? extends IN> source) {
                return source.flatMap(new Function<IN, Publisher<? extends OUT>>(){

                    public Publisher<? extends OUT> apply(IN x) {
                        return Mono.empty();
                    }
                }, null, supplier).next();
            }
        };
    }

    public static <IN, OUT> Function<Stream<IN>, Stream<OUT>> afterStreamComplete(final Supplier<Stream<OUT>> supplier) {
        return new Function<Stream<IN>, Stream<OUT>>(){

            public Stream<OUT> apply(Stream<IN> source) {
                return source.flatMap(new Function<IN, Publisher<? extends OUT>>(){

                    public Publisher<? extends OUT> apply(IN x) {
                        return Stream.empty();
                    }
                }, null, supplier);
            }
        };
    }

    @SafeVarargs
    public static <T> Predicate<T> and(final Predicate<T> ... predicates) {
        return new Predicate<T>(){

            public boolean test(T t) {
                for (Predicate predicate : predicates) {
                    if (predicate.test(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <IN extends OUT, OUT> Function<IN, OUT> cast() {
        return new Function<IN, OUT>(){

            public OUT apply(IN in) {
                return in;
            }
        };
    }

    public static Predicate<Boolean> identity() {
        return new Predicate<Boolean>(){

            public boolean test(Boolean b) {
                return b;
            }
        };
    }

    public static <T> Predicate<T> not(final Predicate<T> predicate) {
        return new Predicate<T>(){

            public boolean test(T t) {
                return !predicate.test(t);
            }
        };
    }

    @SafeVarargs
    public static <T> Predicate<T> or(final Predicate<T> ... predicates) {
        return new Predicate<T>(){

            public boolean test(T t) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Function<Publisher<T>, Promise<T>> promise() {
        return new Function<Publisher<T>, Promise<T>>(){

            public Promise<T> apply(Publisher<T> publisher) {
                return Promise.from(publisher);
            }
        };
    }

    public static <T> Function<Mono<T>, Mono<T>> repeatWhen(final Function<Stream<Long>, ? extends Publisher<?>> f) {
        return new Function<Mono<T>, Mono<T>>(){

            public Mono<T> apply(Mono<T> mono) {
                return ((Stream)mono.as(OperationUtils.stream())).repeatWhen(f).single();
            }
        };
    }

    public static <T> Function<Publisher<T>, Stream<T>> stream() {
        return new Function<Publisher<T>, Stream<T>>(){

            public Stream<T> apply(Publisher<T> publisher) {
                return Stream.from(publisher);
            }
        };
    }
}

