/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.utils;

import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.utils.OperationUtils;
import org.cloudfoundry.utils.ResourceUtils;
import reactor.core.publisher.Mono;
import reactor.fn.Function;
import reactor.rx.Stream;

public final class PaginationUtils {
    private PaginationUtils() {
    }

    public static <U extends PaginatedResponse<?>> Stream<U> requestPages(Function<Integer, Mono<U>> pageSupplier) {
        return (Stream)((Mono)pageSupplier.apply((Object)1)).flatMap(PaginationUtils.requestAdditionalPages(pageSupplier)).as(OperationUtils.stream());
    }

    public static <R extends Resource<?>, U extends PaginatedResponse<R>> Stream<R> requestResources(Function<Integer, Mono<U>> pageSupplier) {
        return PaginationUtils.requestPages(pageSupplier).flatMap(ResourceUtils.extractResources());
    }

    private static <U extends PaginatedResponse<?>> Function<U, Stream<U>> requestAdditionalPages(final Function<Integer, Mono<U>> pageSupplier) {
        return new Function<U, Stream<U>>(){

            public Stream<U> apply(U response) {
                Integer totalPages = response.getTotalPages();
                if (totalPages == null) {
                    throw new IllegalStateException(String.format("Page response (class %s) has no total pages set", response.getClass().getCanonicalName()));
                }
                return Stream.range((int)2, (int)(totalPages - 1)).flatMap(PaginationUtils.requestPage(pageSupplier)).startWith(response);
            }
        };
    }

    private static <U extends PaginatedResponse<?>> Function<Integer, Mono<U>> requestPage(final Function<Integer, Mono<U>> pageSupplier) {
        return new Function<Integer, Mono<U>>(){

            public Mono<U> apply(Integer page) {
                return (Mono)pageSupplier.apply((Object)page);
            }
        };
    }
}

