/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.utils;

import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.Resource;
import reactor.fn.Function;
import reactor.rx.Stream;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static <R extends Resource<T>, T> Function<R, T> extractEntity() {
        return new Function<R, T>(){

            public T apply(R resource) {
                return ResourceUtils.getEntity(resource);
            }
        };
    }

    public static Function<Resource<?>, String> extractId() {
        return new Function<Resource<?>, String>(){

            public String apply(Resource<?> resource) {
                return ResourceUtils.getId(resource);
            }
        };
    }

    public static <R extends Resource<?>, U extends PaginatedResponse<R>> Function<U, Stream<R>> extractResources() {
        return new Function<U, Stream<R>>(){

            public Stream<R> apply(U pageResponse) {
                return ResourceUtils.getResources(pageResponse);
            }
        };
    }

    public static <T> T getEntity(Resource<T> resource) {
        return (T)resource.getEntity();
    }

    public static String getId(Resource<?> resource) {
        return resource.getMetadata().getId();
    }

    public static <R extends Resource<?>, U extends PaginatedResponse<R>> Stream<R> getResources(U response) {
        return Stream.fromIterable((Iterable)response.getResources());
    }
}

