/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class StringMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = -2835780629130145581L;

    StringMap(Map<String, Object> entries) {
        super(entries);
    }

    public static StringMapBuilder builder() {
        return new StringMapBuilder();
    }

    public static class StringMapBuilder {
        private ArrayList<String> entries$key;
        private ArrayList<Object> entries$value;

        StringMapBuilder() {
        }

        public StringMapBuilder entry(String entryKey, Object entryValue) {
            if (this.entries$key == null) {
                this.entries$key = new ArrayList();
                this.entries$value = new ArrayList();
            }
            this.entries$key.add(entryKey);
            this.entries$value.add(entryValue);
            return this;
        }

        public StringMapBuilder entries(Map<? extends String, ? extends Object> entries) {
            if (this.entries$key == null) {
                this.entries$key = new ArrayList();
                this.entries$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : entries.entrySet()) {
                this.entries$key.add($lombokEntry.getKey());
                this.entries$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public StringMap build() {
            Map<String, Object> entries;
            switch (this.entries$key == null ? 0 : this.entries$key.size()) {
                case 0: {
                    entries = Collections.emptyMap();
                    break;
                }
                case 1: {
                    entries = Collections.singletonMap(this.entries$key.get(0), this.entries$value.get(0));
                    break;
                }
                default: {
                    entries = new LinkedHashMap<String, Object>(this.entries$key.size() < 0x40000000 ? 1 + this.entries$key.size() + (this.entries$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.entries$key.size(); ++$i) {
                        entries.put(this.entries$key.get($i), this.entries$value.get($i));
                    }
                    entries = Collections.unmodifiableMap(entries);
                }
            }
            return new StringMap(entries);
        }

        public String toString() {
            return "StringMap.StringMapBuilder(entries$key=" + this.entries$key + ", entries$value=" + this.entries$value + ")";
        }
    }
}

