/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.utils;

import org.cloudfoundry.client.Validatable;
import org.cloudfoundry.client.ValidationResult;
import org.cloudfoundry.utils.RequestValidationException;
import reactor.core.publisher.Mono;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static <T extends Validatable> Mono<T> validate(T request) {
        ValidationResult validationResult = request.isValid();
        if (validationResult.getStatus() == ValidationResult.Status.INVALID) {
            return Mono.error((Throwable)new RequestValidationException(validationResult));
        }
        return Mono.just(request);
    }
}

