/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.utils.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.junit.Assert;

public abstract class TestObjects {
    private TestObjects() {
    }

    public static <T> T fill(T builder) {
        return TestObjects.fill(builder, "");
    }

    public static <T> T fill(T builder, String modifier) {
        Class<?> builderClass = builder.getClass();
        Class<?> builtType = TestObjects.getBuiltType(builderClass, true);
        if (TestObjects.isPaginatedType(builtType)) {
            Assert.fail((String)("Builder argument " + builder + " builds a paginated type.  Use fillPage instead."));
        }
        TestObjects.callSetters(builder, modifier, builderClass, builtType, false);
        return builder;
    }

    public static <T> T fillPage(T builder) {
        return TestObjects.fillPage(builder, "");
    }

    public static <T> T fillPage(T builder, String modifier) {
        Class<?> builderClass = builder.getClass();
        Class<?> builtType = TestObjects.getBuiltType(builderClass, true);
        if (!TestObjects.isPaginatedType(builtType)) {
            Assert.fail((String)("Builder argument " + builder + " does not build a paginated type.  Use fill instead."));
        }
        TestObjects.callSetters(builder, modifier, builderClass, builtType, true);
        return builder;
    }

    private static <O> O buildFilled(Class<O> builtClass, String modifier) {
        try {
            Method builderMethod = builtClass.getMethod("builder", new Class[0]);
            Class<?> builderClass = builderMethod.getReturnType();
            Object builder = TestObjects.fill(builderMethod.invoke(null, new Object[0]), modifier);
            Object built = builderClass.getMethod("build", new Class[0]).invoke(builder, new Object[0]);
            return (O)built;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Assert.fail((String)("Cannot get builder for sub-object of type " + builtClass));
            return null;
        }
    }

    private static <O> O buildTestValue(Method m, Class<O> clazz, String modifier, boolean isPaginated, boolean hasGetterOnBuiltType) {
        if (clazz.getSimpleName().endsWith("Entity")) {
            return TestObjects.buildFilled(clazz, modifier);
        }
        if (clazz.getSimpleName().endsWith("Metadata")) {
            return TestObjects.buildFilled(clazz, modifier);
        }
        if (isPaginated) {
            if (m.getName().equals("resultsPerPage")) {
                return null;
            }
            if (m.getName().equals("orderDirection")) {
                return null;
            }
        }
        if (!hasGetterOnBuiltType) {
            return null;
        }
        if (clazz == Boolean.class) {
            return (O)Boolean.valueOf(true);
        }
        if (clazz == Integer.class) {
            return (O)Integer.valueOf(1);
        }
        if (clazz == Long.class) {
            return (O)Long.valueOf(1L);
        }
        if (clazz == Float.class) {
            return (O)Float.valueOf(1.0f);
        }
        if (clazz == Double.class) {
            return (O)Double.valueOf(1.0);
        }
        if (clazz == String.class) {
            return (O)String.valueOf("test-" + modifier + m.getName());
        }
        if (clazz == Map.class) {
            return (O)Collections.emptyMap();
        }
        if (clazz == List.class) {
            return (O)Collections.emptyList();
        }
        if (clazz == Collection.class) {
            return null;
        }
        return null;
    }

    private static <T> void callSetters(T builder, String modifier, Class<?> builderClass, Class<?> builtType, boolean isPaginated) {
        for (Method m : builderClass.getDeclaredMethods()) {
            Object parmValue;
            if (!Modifier.isPublic(m.getModifiers())) continue;
            Class<?>[] parmTypes = m.getParameterTypes();
            Class<?> returnType = m.getReturnType();
            if (parmTypes.length != 1 || returnType != builderClass || (parmValue = TestObjects.buildTestValue(m, parmTypes[0], modifier, isPaginated, TestObjects.hasGetterFor(m.getName(), builtType))) == null) continue;
            TestObjects.invokeSetter(builder, m, parmValue);
        }
    }

    private static Class<?> getBuiltType(Class<?> builderClass, boolean failIfNotBuilder) {
        if (builderClass.getSimpleName().endsWith("Builder")) {
            try {
                Class<?> builtType = builderClass.getMethod("build", new Class[0]).getReturnType();
                if (builtType.getMethod("builder", new Class[0]).getReturnType() == builderClass) {
                    return builtType;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (failIfNotBuilder) {
            Assert.fail((String)("Unrecognized builder type " + builderClass));
        }
        return null;
    }

    private static String getterName(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static boolean hasGetterFor(String name, Class<?> clazz) {
        try {
            clazz.getMethod(TestObjects.getterName(name), new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static <T, V> T invokeSetter(T builder, Method m, V parmValue) {
        try {
            builder = m.invoke(builder, parmValue);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Assert.fail((String)("test object cannot be filled at method " + m + ". Exception " + e));
        }
        return builder;
    }

    private static boolean isBuilderType(Class<?> clazz) {
        return null != TestObjects.getBuiltType(clazz, false);
    }

    private static boolean isPaginatedType(Class<?> builtType) {
        return PaginatedRequest.class.isAssignableFrom(builtType) || PaginatedResponse.class.isAssignableFrom(builtType);
    }
}

