/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.utils.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.atteo.evo.inflector.English;
import org.junit.Assert;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.util.Exceptions;
import reactor.core.util.ReactiveStateUtils;
import reactor.fn.Consumer;
import reactor.fn.Supplier;
import reactor.fn.tuple.Tuple;
import reactor.fn.tuple.Tuple2;

public final class TestSubscriber<T>
implements Subscriber<T> {
    private final Queue<T> actuals = new LinkedList<T>();
    private final Queue<Consumer<T>> expectations = new LinkedList<Consumer<T>>();
    private final CountDownLatch latch = new CountDownLatch(1);
    private Integer countExpectation;
    private volatile Throwable errorActual;
    private Consumer<? super Throwable> errorExpectation;
    private Consumer<Tuple2<Long, Long>> performanceCallback;
    private Consumer<Subscription> scanningCallback;
    private long startTime;
    private Subscription subscription;

    public TestSubscriber<T> assertCount(Integer expected) {
        this.countExpectation = expected;
        return this;
    }

    public TestSubscriber<T> assertEquals(final T expected) {
        this.assertThat(new Consumer<T>(){

            public void accept(T actual) {
                Assert.assertEquals((Object)expected, actual);
            }
        });
        return this;
    }

    public TestSubscriber<T> assertError(final Class<? extends Throwable> expected) {
        this.errorExpectation = new Consumer<Throwable>(){

            public void accept(Throwable actual) {
                StringWriter writer = new StringWriter();
                actual.printStackTrace(new PrintWriter(writer));
                Assert.assertEquals((String)String.format("Unexpected error %s", writer.toString()), (Object)expected, actual.getClass());
            }
        };
        return this;
    }

    public TestSubscriber<T> assertThat(Consumer<T> expectation) {
        this.expectations.add(expectation);
        return this;
    }

    public void onComplete() {
        this.latch.countDown();
    }

    public void onError(Throwable t) {
        Exceptions.throwIfFatal((Throwable)t);
        this.errorActual = t;
        this.latch.countDown();
    }

    public void onNext(T t) {
        this.actuals.add(t);
        if (this.scanningCallback != null) {
            this.scanningCallback.accept((Object)this.subscription);
        }
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        this.startTime = System.currentTimeMillis();
        s.request(Long.MAX_VALUE);
    }

    public TestSubscriber<T> setPerformanceCallback(Consumer<Tuple2<Long, Long>> performanceCallback) {
        this.performanceCallback = performanceCallback;
        return this;
    }

    public TestSubscriber<T> setPerformanceLoggerName(final Supplier<String> name) {
        return this.setPerformanceCallback(new Consumer<Tuple2<Long, Long>>(){

            public void accept(Tuple2<Long, Long> tuple) {
                Long startTime = (Long)tuple.t1;
                Long finishTime = (Long)tuple.t2;
                Logger logger = LoggerFactory.getLogger((String)String.format("cloudfoundry-client.performance.%s", name.get()));
                if (logger.isDebugEnabled()) {
                    logger.debug("{} ms", (Object)(finishTime - startTime));
                }
            }
        });
    }

    public TestSubscriber<T> setScanningCallback(Consumer<Subscription> scanningCallback) {
        this.scanningCallback = scanningCallback;
        return this;
    }

    public TestSubscriber<T> setScanningLoggerName(final Supplier<String> name) {
        return this.setScanningCallback(new Consumer<Subscription>(){

            public void accept(Subscription subscription) {
                Logger logger = LoggerFactory.getLogger((String)String.format("cloudfoundry-client.scan.%s", name.get()));
                if (logger.isDebugEnabled()) {
                    logger.debug(ReactiveStateUtils.scan((Object)subscription).toString());
                }
            }
        });
    }

    public void verify(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.latch.await(timeout, unit)) {
            throw new IllegalStateException("Subscriber timed out");
        }
        if (this.performanceCallback != null) {
            this.performanceCallback.accept((Object)Tuple.of((Object)this.startTime, (Object)System.currentTimeMillis()));
        }
        this.verifyError();
        this.verifyCount();
        this.verifyItems();
    }

    private void verifyCount() {
        if (this.countExpectation != null) {
            Assert.assertEquals((String)"Item count expectation not met", (Object)this.countExpectation, (Object)this.actuals.size());
        }
    }

    private void verifyError() {
        if (this.errorActual != null) {
            if (this.errorExpectation == null) {
                throw new AssertionError("Unexpected error", this.errorActual);
            }
            this.errorExpectation.accept((Object)this.errorActual);
            this.errorExpectation = null;
        }
        if (this.errorExpectation != null) {
            Assert.fail((String)"Unexpected completion. Error expectation not met.");
        }
    }

    private void verifyItems() {
        for (Object actual : this.actuals) {
            Consumer<T> expectation = this.expectations.poll();
            if (expectation != null) {
                expectation.accept(actual);
                continue;
            }
            if (this.countExpectation != null) continue;
            Assert.fail((String)String.format("Unexpected item %s", actual));
        }
        if (!this.expectations.isEmpty()) {
            int count = this.expectations.size();
            Assert.fail((String)String.format("Unexpected completion. %d %s not met.", count, English.plural((String)"expectation", (int)count)));
        }
    }
}

