package org.cloudfoundry.client.v2.domains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _CreateDomainRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CreateDomainRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CreateDomainRequest"})
public final class CreateDomainRequest extends org.cloudfoundry.client.v2.domains._CreateDomainRequest {
  private final String name;
  private final @Nullable String owningOrganizationId;
  private final Boolean wildcard;

  private CreateDomainRequest(CreateDomainRequest.Builder builder) {
    this.name = builder.name;
    this.owningOrganizationId = builder.owningOrganizationId;
    this.wildcard = builder.wildcard;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The owning organization id
   */
  @Override
  public @Nullable String getOwningOrganizationId() {
    return owningOrganizationId;
  }

  /**
   * The wildcard
   */
  @Override
  public Boolean getWildcard() {
    return wildcard;
  }

  /**
   * This instance is equal to all instances of {@code CreateDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateDomainRequest
        && equalTo((CreateDomainRequest) another);
  }

  private boolean equalTo(CreateDomainRequest another) {
    return name.equals(another.name)
        && Objects.equals(owningOrganizationId, another.owningOrganizationId)
        && wildcard.equals(another.wildcard);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code owningOrganizationId}, {@code wildcard}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(owningOrganizationId);
    h = h * 17 + wildcard.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateDomainRequest{"
        + "name=" + name
        + ", owningOrganizationId=" + owningOrganizationId
        + ", wildcard=" + wildcard
        + "}";
  }

  /**
   * Creates a builder for {@link CreateDomainRequest CreateDomainRequest}.
   * @return A new CreateDomainRequest builder
   */
  public static CreateDomainRequest.Builder builder() {
    return new CreateDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateDomainRequest CreateDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_WILDCARD = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private String owningOrganizationId;
    private Boolean wildcard;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateDomainRequest instance) {
      return from((_CreateDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      String owningOrganizationIdValue = instance.getOwningOrganizationId();
      if (owningOrganizationIdValue != null) {
        owningOrganizationId(owningOrganizationIdValue);
      }
      wildcard(instance.getWildcard());
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateDomainRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateDomainRequest#getOwningOrganizationId() owningOrganizationId} attribute.
     * @param owningOrganizationId The value for owningOrganizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationId(@Nullable String owningOrganizationId) {
      this.owningOrganizationId = owningOrganizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateDomainRequest#getWildcard() wildcard} attribute.
     * @param wildcard The value for wildcard 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder wildcard(Boolean wildcard) {
      this.wildcard = Objects.requireNonNull(wildcard, "wildcard");
      initBits &= ~INIT_BIT_WILDCARD;
      return this;
    }

    /**
     * Builds a new {@link CreateDomainRequest CreateDomainRequest}.
     * @return An immutable instance of CreateDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_WILDCARD) != 0) attributes.add("wildcard");
      return "Cannot build CreateDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
