package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _DomainEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DomainEntity.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_DomainEntity"})
public final class DomainEntity extends org.cloudfoundry.client.v2.domains._DomainEntity {
  private final @Nullable String name;
  private final @Nullable String owningOrganizationId;
  private final @Nullable String owningOrganizationUrl;
  private final @Nullable String routerGroupId;
  private final @Nullable String routerGroupType;
  private final @Nullable List<String> sharedOrganizations;
  private final @Nullable String spacesUrl;

  private DomainEntity(DomainEntity.Builder builder) {
    this.name = builder.name;
    this.owningOrganizationId = builder.owningOrganizationId;
    this.owningOrganizationUrl = builder.owningOrganizationUrl;
    this.routerGroupId = builder.routerGroupId;
    this.routerGroupType = builder.routerGroupType;
    this.sharedOrganizations = builder.sharedOrganizations == null ? null : createUnmodifiableList(true, builder.sharedOrganizations);
    this.spacesUrl = builder.spacesUrl;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The owning organization id
   */
  @JsonProperty("owning_organization_guid")
  @Override
  public @Nullable String getOwningOrganizationId() {
    return owningOrganizationId;
  }

  /**
   * The owning organization url
   */
  @JsonProperty("owning_organization_url")
  @Override
  public @Nullable String getOwningOrganizationUrl() {
    return owningOrganizationUrl;
  }

  /**
   * The router group id
   */
  @JsonProperty("router_group_guid")
  @Override
  public @Nullable String getRouterGroupId() {
    return routerGroupId;
  }

  /**
   * The router group type
   */
  @JsonProperty("router_group_type")
  @Override
  public @Nullable String getRouterGroupType() {
    return routerGroupType;
  }

  /**
   * The shared organizations
   */
  @JsonProperty("shared_organizations")
  @Override
  public @Nullable List<String> getSharedOrganizations() {
    return sharedOrganizations;
  }

  /**
   * The spaces url
   */
  @JsonProperty("spaces_url")
  @Override
  public @Nullable String getSpacesUrl() {
    return spacesUrl;
  }

  /**
   * This instance is equal to all instances of {@code DomainEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DomainEntity
        && equalTo((DomainEntity) another);
  }

  private boolean equalTo(DomainEntity another) {
    return Objects.equals(name, another.name)
        && Objects.equals(owningOrganizationId, another.owningOrganizationId)
        && Objects.equals(owningOrganizationUrl, another.owningOrganizationUrl)
        && Objects.equals(routerGroupId, another.routerGroupId)
        && Objects.equals(routerGroupType, another.routerGroupType)
        && Objects.equals(sharedOrganizations, another.sharedOrganizations)
        && Objects.equals(spacesUrl, another.spacesUrl);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code owningOrganizationId}, {@code owningOrganizationUrl}, {@code routerGroupId}, {@code routerGroupType}, {@code sharedOrganizations}, {@code spacesUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(owningOrganizationId);
    h = h * 17 + Objects.hashCode(owningOrganizationUrl);
    h = h * 17 + Objects.hashCode(routerGroupId);
    h = h * 17 + Objects.hashCode(routerGroupType);
    h = h * 17 + Objects.hashCode(sharedOrganizations);
    h = h * 17 + Objects.hashCode(spacesUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code DomainEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DomainEntity{"
        + "name=" + name
        + ", owningOrganizationId=" + owningOrganizationId
        + ", owningOrganizationUrl=" + owningOrganizationUrl
        + ", routerGroupId=" + routerGroupId
        + ", routerGroupType=" + routerGroupType
        + ", sharedOrganizations=" + sharedOrganizations
        + ", spacesUrl=" + spacesUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.domains._DomainEntity {
    String name;
    String owningOrganizationId;
    String owningOrganizationUrl;
    String routerGroupId;
    String routerGroupType;
    List<String> sharedOrganizations = null;
    String spacesUrl;
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("owning_organization_guid")
    public void setOwningOrganizationId(@Nullable String owningOrganizationId) {
      this.owningOrganizationId = owningOrganizationId;
    }
    @JsonProperty("owning_organization_url")
    public void setOwningOrganizationUrl(@Nullable String owningOrganizationUrl) {
      this.owningOrganizationUrl = owningOrganizationUrl;
    }
    @JsonProperty("router_group_guid")
    public void setRouterGroupId(@Nullable String routerGroupId) {
      this.routerGroupId = routerGroupId;
    }
    @JsonProperty("router_group_type")
    public void setRouterGroupType(@Nullable String routerGroupType) {
      this.routerGroupType = routerGroupType;
    }
    @JsonProperty("shared_organizations")
    public void setSharedOrganizations(@Nullable List<String> sharedOrganizations) {
      this.sharedOrganizations = sharedOrganizations;
    }
    @JsonProperty("spaces_url")
    public void setSpacesUrl(@Nullable String spacesUrl) {
      this.spacesUrl = spacesUrl;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOwningOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOwningOrganizationUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupType() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSharedOrganizations() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpacesUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static DomainEntity fromJson(Json json) {
    DomainEntity.Builder builder = DomainEntity.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.owningOrganizationId != null) {
      builder.owningOrganizationId(json.owningOrganizationId);
    }
    if (json.owningOrganizationUrl != null) {
      builder.owningOrganizationUrl(json.owningOrganizationUrl);
    }
    if (json.routerGroupId != null) {
      builder.routerGroupId(json.routerGroupId);
    }
    if (json.routerGroupType != null) {
      builder.routerGroupType(json.routerGroupType);
    }
    if (json.sharedOrganizations != null) {
      builder.addAllSharedOrganizations(json.sharedOrganizations);
    }
    if (json.spacesUrl != null) {
      builder.spacesUrl(json.spacesUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DomainEntity DomainEntity}.
   * @return A new DomainEntity builder
   */
  public static DomainEntity.Builder builder() {
    return new DomainEntity.Builder();
  }

  /**
   * Builds instances of type {@link DomainEntity DomainEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String name;
    private String owningOrganizationId;
    private String owningOrganizationUrl;
    private String routerGroupId;
    private String routerGroupType;
    private List<String> sharedOrganizations = null;
    private String spacesUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DomainEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DomainEntity instance) {
      return from((_DomainEntity) instance);
    }

    /**
     * Copy abstract value type {@code _DomainEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DomainEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String owningOrganizationIdValue = instance.getOwningOrganizationId();
      if (owningOrganizationIdValue != null) {
        owningOrganizationId(owningOrganizationIdValue);
      }
      String owningOrganizationUrlValue = instance.getOwningOrganizationUrl();
      if (owningOrganizationUrlValue != null) {
        owningOrganizationUrl(owningOrganizationUrlValue);
      }
      String routerGroupIdValue = instance.getRouterGroupId();
      if (routerGroupIdValue != null) {
        routerGroupId(routerGroupIdValue);
      }
      String routerGroupTypeValue = instance.getRouterGroupType();
      if (routerGroupTypeValue != null) {
        routerGroupType(routerGroupTypeValue);
      }
      List<String> sharedOrganizationsValue = instance.getSharedOrganizations();
      if (sharedOrganizationsValue != null) {
        addAllSharedOrganizations(sharedOrganizationsValue);
      }
      String spacesUrlValue = instance.getSpacesUrl();
      if (spacesUrlValue != null) {
        spacesUrl(spacesUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DomainEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _DomainEntity#getOwningOrganizationId() owningOrganizationId} attribute.
     * @param owningOrganizationId The value for owningOrganizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationId(@Nullable String owningOrganizationId) {
      this.owningOrganizationId = owningOrganizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _DomainEntity#getOwningOrganizationUrl() owningOrganizationUrl} attribute.
     * @param owningOrganizationUrl The value for owningOrganizationUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationUrl(@Nullable String owningOrganizationUrl) {
      this.owningOrganizationUrl = owningOrganizationUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _DomainEntity#getRouterGroupId() routerGroupId} attribute.
     * @param routerGroupId The value for routerGroupId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routerGroupId(@Nullable String routerGroupId) {
      this.routerGroupId = routerGroupId;
      return this;
    }

    /**
     * Initializes the value for the {@link _DomainEntity#getRouterGroupType() routerGroupType} attribute.
     * @param routerGroupType The value for routerGroupType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routerGroupType(@Nullable String routerGroupType) {
      this.routerGroupType = routerGroupType;
      return this;
    }

    /**
     * Adds one element to {@link _DomainEntity#getSharedOrganizations() sharedOrganizations} list.
     * @param element A sharedOrganizations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sharedOrganization(String element) {
      if (this.sharedOrganizations == null) {
        this.sharedOrganizations = new ArrayList<String>();
      }
      this.sharedOrganizations.add(Objects.requireNonNull(element, "sharedOrganizations element"));
      return this;
    }

    /**
     * Adds elements to {@link _DomainEntity#getSharedOrganizations() sharedOrganizations} list.
     * @param elements An array of sharedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sharedOrganization(String... elements) {
      if (this.sharedOrganizations == null) {
        this.sharedOrganizations = new ArrayList<String>();
      }
      for (String element : elements) {
        this.sharedOrganizations.add(Objects.requireNonNull(element, "sharedOrganizations element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _DomainEntity#getSharedOrganizations() sharedOrganizations} list.
     * @param elements An iterable of sharedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sharedOrganizations(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.sharedOrganizations = null;
        return this;
      }
      this.sharedOrganizations = new ArrayList<String>();
      return addAllSharedOrganizations(elements);
    }

    /**
     * Adds elements to {@link _DomainEntity#getSharedOrganizations() sharedOrganizations} list.
     * @param elements An iterable of sharedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSharedOrganizations(Iterable<String> elements) {
      Objects.requireNonNull(elements, "sharedOrganizations element");
      if (this.sharedOrganizations == null) {
        this.sharedOrganizations = new ArrayList<String>();
      }
      for (String element : elements) {
        this.sharedOrganizations.add(Objects.requireNonNull(element, "sharedOrganizations element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DomainEntity#getSpacesUrl() spacesUrl} attribute.
     * @param spacesUrl The value for spacesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spacesUrl(@Nullable String spacesUrl) {
      this.spacesUrl = spacesUrl;
      return this;
    }

    /**
     * Builds a new {@link DomainEntity DomainEntity}.
     * @return An immutable instance of DomainEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DomainEntity build() {
      return new DomainEntity(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
