package org.cloudfoundry.client.v2.environmentvariablegroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _GetStagingEnvironmentVariablesResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetStagingEnvironmentVariablesResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetStagingEnvironmentVariablesResponse"})
public final class GetStagingEnvironmentVariablesResponse
    extends org.cloudfoundry.client.v2.environmentvariablegroups._GetStagingEnvironmentVariablesResponse {
  private final Map<String, Object> environmentVariables;

  private GetStagingEnvironmentVariablesResponse(GetStagingEnvironmentVariablesResponse.Builder builder) {
    this.environmentVariables = createUnmodifiableMap(false, false, builder.environmentVariables);
  }

  /**
   * The environment variables
   */
  @JsonProperty("environmentVariables")
  @Override
  public Map<String, Object> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * This instance is equal to all instances of {@code GetStagingEnvironmentVariablesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetStagingEnvironmentVariablesResponse
        && equalTo((GetStagingEnvironmentVariablesResponse) another);
  }

  private boolean equalTo(GetStagingEnvironmentVariablesResponse another) {
    return environmentVariables.equals(another.environmentVariables);
  }

  /**
   * Computes a hash code from attributes: {@code environmentVariables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + environmentVariables.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetStagingEnvironmentVariablesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetStagingEnvironmentVariablesResponse{"
        + "environmentVariables=" + environmentVariables
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.environmentvariablegroups._GetStagingEnvironmentVariablesResponse {
    Map<String, Object> environmentVariables;
    @JsonProperty("environmentVariables")
    public void setEnvironmentVariables(Map<String, Object> environmentVariables) {
      this.environmentVariables = environmentVariables;
    }
    @Override
    public Map<String, Object> getEnvironmentVariables() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static GetStagingEnvironmentVariablesResponse fromJson(Json json) {
    GetStagingEnvironmentVariablesResponse.Builder builder = GetStagingEnvironmentVariablesResponse.builder();
    if (json.environmentVariables != null) {
      builder.putAllEnvironmentVariables(json.environmentVariables);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetStagingEnvironmentVariablesResponse GetStagingEnvironmentVariablesResponse}.
   * @return A new GetStagingEnvironmentVariablesResponse builder
   */
  public static GetStagingEnvironmentVariablesResponse.Builder builder() {
    return new GetStagingEnvironmentVariablesResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetStagingEnvironmentVariablesResponse GetStagingEnvironmentVariablesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Map<String, Object> environmentVariables = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetStagingEnvironmentVariablesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetStagingEnvironmentVariablesResponse instance) {
      return from((_GetStagingEnvironmentVariablesResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetStagingEnvironmentVariablesResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetStagingEnvironmentVariablesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      putAllEnvironmentVariables(instance.getEnvironmentVariables());
      return this;
    }

    /**
     * Put one entry to the {@link _GetStagingEnvironmentVariablesResponse#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, Object value) {
      this.environmentVariables.put(
          Objects.requireNonNull(key, "environmentVariables key"),
          Objects.requireNonNull(value, "environmentVariables value"));
      return this;
    }

    /**
     * Put one entry to the {@link _GetStagingEnvironmentVariablesResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentVariables.put(
          Objects.requireNonNull(k, "environmentVariables key"),
          Objects.requireNonNull(v, "environmentVariables value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _GetStagingEnvironmentVariablesResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(Map<String, ? extends Object> environmentVariables) {
      this.environmentVariables.clear();
      return putAllEnvironmentVariables(environmentVariables);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _GetStagingEnvironmentVariablesResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
      for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.environmentVariables.put(
            Objects.requireNonNull(k, "environmentVariables key"),
            Objects.requireNonNull(v, "environmentVariables value"));
      }
      return this;
    }

    /**
     * Builds a new {@link GetStagingEnvironmentVariablesResponse GetStagingEnvironmentVariablesResponse}.
     * @return An immutable instance of GetStagingEnvironmentVariablesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetStagingEnvironmentVariablesResponse build() {
      return new GetStagingEnvironmentVariablesResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
