package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * Immutable implementation of {@link _GetOrganizationUserRolesRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetOrganizationUserRolesRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetOrganizationUserRolesRequest"})
public final class GetOrganizationUserRolesRequest
    extends org.cloudfoundry.client.v2.organizations._GetOrganizationUserRolesRequest {
  private final String organizationId;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private GetOrganizationUserRolesRequest(GetOrganizationUserRolesRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code GetOrganizationUserRolesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetOrganizationUserRolesRequest
        && equalTo((GetOrganizationUserRolesRequest) another);
  }

  private boolean equalTo(GetOrganizationUserRolesRequest another) {
    return organizationId.equals(another.organizationId)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + organizationId.hashCode();
    h = h * 17 + Objects.hashCode(orderDirection);
    h = h * 17 + Objects.hashCode(page);
    h = h * 17 + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code GetOrganizationUserRolesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetOrganizationUserRolesRequest{"
        + "organizationId=" + organizationId
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link GetOrganizationUserRolesRequest GetOrganizationUserRolesRequest}.
   * @return A new GetOrganizationUserRolesRequest builder
   */
  public static GetOrganizationUserRolesRequest.Builder builder() {
    return new GetOrganizationUserRolesRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetOrganizationUserRolesRequest GetOrganizationUserRolesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String organizationId;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetOrganizationUserRolesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetOrganizationUserRolesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetOrganizationUserRolesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetOrganizationUserRolesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.organizations._GetOrganizationUserRolesRequest) {
        org.cloudfoundry.client.v2.organizations._GetOrganizationUserRolesRequest instance = (org.cloudfoundry.client.v2.organizations._GetOrganizationUserRolesRequest) object;
        organizationId(instance.getOrganizationId());
      }
    }

    /**
     * Initializes the value for the {@link _GetOrganizationUserRolesRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetOrganizationUserRolesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetOrganizationUserRolesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetOrganizationUserRolesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link GetOrganizationUserRolesRequest GetOrganizationUserRolesRequest}.
     * @return An immutable instance of GetOrganizationUserRolesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetOrganizationUserRolesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetOrganizationUserRolesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build GetOrganizationUserRolesRequest, some of required attributes are not set " + attributes;
    }
  }
}
