package org.cloudfoundry.client.v2.privatedomains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _PrivateDomainEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code PrivateDomainEntity.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_PrivateDomainEntity"})
public final class PrivateDomainEntity extends org.cloudfoundry.client.v2.privatedomains._PrivateDomainEntity {
  private final @Nullable String name;
  private final @Nullable String owningOrganizationId;
  private final @Nullable String owningOrganizationUrl;
  private final @Nullable String sharedOrganizationsUrl;

  private PrivateDomainEntity(PrivateDomainEntity.Builder builder) {
    this.name = builder.name;
    this.owningOrganizationId = builder.owningOrganizationId;
    this.owningOrganizationUrl = builder.owningOrganizationUrl;
    this.sharedOrganizationsUrl = builder.sharedOrganizationsUrl;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The owning organization id
   */
  @JsonProperty("owning_organization_guid")
  @Override
  public @Nullable String getOwningOrganizationId() {
    return owningOrganizationId;
  }

  /**
   * The owning organization url
   */
  @JsonProperty("owning_organization_url")
  @Override
  public @Nullable String getOwningOrganizationUrl() {
    return owningOrganizationUrl;
  }

  /**
   * The shared organizations url
   */
  @JsonProperty("shared_organizations_url")
  @Override
  public @Nullable String getSharedOrganizationsUrl() {
    return sharedOrganizationsUrl;
  }

  /**
   * This instance is equal to all instances of {@code PrivateDomainEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof PrivateDomainEntity
        && equalTo((PrivateDomainEntity) another);
  }

  private boolean equalTo(PrivateDomainEntity another) {
    return Objects.equals(name, another.name)
        && Objects.equals(owningOrganizationId, another.owningOrganizationId)
        && Objects.equals(owningOrganizationUrl, another.owningOrganizationUrl)
        && Objects.equals(sharedOrganizationsUrl, another.sharedOrganizationsUrl);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code owningOrganizationId}, {@code owningOrganizationUrl}, {@code sharedOrganizationsUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(owningOrganizationId);
    h = h * 17 + Objects.hashCode(owningOrganizationUrl);
    h = h * 17 + Objects.hashCode(sharedOrganizationsUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code PrivateDomainEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PrivateDomainEntity{"
        + "name=" + name
        + ", owningOrganizationId=" + owningOrganizationId
        + ", owningOrganizationUrl=" + owningOrganizationUrl
        + ", sharedOrganizationsUrl=" + sharedOrganizationsUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.privatedomains._PrivateDomainEntity {
    String name;
    String owningOrganizationId;
    String owningOrganizationUrl;
    String sharedOrganizationsUrl;
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("owning_organization_guid")
    public void setOwningOrganizationId(@Nullable String owningOrganizationId) {
      this.owningOrganizationId = owningOrganizationId;
    }
    @JsonProperty("owning_organization_url")
    public void setOwningOrganizationUrl(@Nullable String owningOrganizationUrl) {
      this.owningOrganizationUrl = owningOrganizationUrl;
    }
    @JsonProperty("shared_organizations_url")
    public void setSharedOrganizationsUrl(@Nullable String sharedOrganizationsUrl) {
      this.sharedOrganizationsUrl = sharedOrganizationsUrl;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOwningOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOwningOrganizationUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSharedOrganizationsUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static PrivateDomainEntity fromJson(Json json) {
    PrivateDomainEntity.Builder builder = PrivateDomainEntity.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.owningOrganizationId != null) {
      builder.owningOrganizationId(json.owningOrganizationId);
    }
    if (json.owningOrganizationUrl != null) {
      builder.owningOrganizationUrl(json.owningOrganizationUrl);
    }
    if (json.sharedOrganizationsUrl != null) {
      builder.sharedOrganizationsUrl(json.sharedOrganizationsUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link PrivateDomainEntity PrivateDomainEntity}.
   * @return A new PrivateDomainEntity builder
   */
  public static PrivateDomainEntity.Builder builder() {
    return new PrivateDomainEntity.Builder();
  }

  /**
   * Builds instances of type {@link PrivateDomainEntity PrivateDomainEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String name;
    private String owningOrganizationId;
    private String owningOrganizationUrl;
    private String sharedOrganizationsUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PrivateDomainEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PrivateDomainEntity instance) {
      return from((_PrivateDomainEntity) instance);
    }

    /**
     * Copy abstract value type {@code _PrivateDomainEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_PrivateDomainEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String owningOrganizationIdValue = instance.getOwningOrganizationId();
      if (owningOrganizationIdValue != null) {
        owningOrganizationId(owningOrganizationIdValue);
      }
      String owningOrganizationUrlValue = instance.getOwningOrganizationUrl();
      if (owningOrganizationUrlValue != null) {
        owningOrganizationUrl(owningOrganizationUrlValue);
      }
      String sharedOrganizationsUrlValue = instance.getSharedOrganizationsUrl();
      if (sharedOrganizationsUrlValue != null) {
        sharedOrganizationsUrl(sharedOrganizationsUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _PrivateDomainEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _PrivateDomainEntity#getOwningOrganizationId() owningOrganizationId} attribute.
     * @param owningOrganizationId The value for owningOrganizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationId(@Nullable String owningOrganizationId) {
      this.owningOrganizationId = owningOrganizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _PrivateDomainEntity#getOwningOrganizationUrl() owningOrganizationUrl} attribute.
     * @param owningOrganizationUrl The value for owningOrganizationUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationUrl(@Nullable String owningOrganizationUrl) {
      this.owningOrganizationUrl = owningOrganizationUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _PrivateDomainEntity#getSharedOrganizationsUrl() sharedOrganizationsUrl} attribute.
     * @param sharedOrganizationsUrl The value for sharedOrganizationsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sharedOrganizationsUrl(@Nullable String sharedOrganizationsUrl) {
      this.sharedOrganizationsUrl = sharedOrganizationsUrl;
      return this;
    }

    /**
     * Builds a new {@link PrivateDomainEntity PrivateDomainEntity}.
     * @return An immutable instance of PrivateDomainEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PrivateDomainEntity build() {
      return new PrivateDomainEntity(this);
    }
  }
}
