package org.cloudfoundry.client.v2.routemappings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _CreateRouteMappingRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CreateRouteMappingRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CreateRouteMappingRequest"})
public final class CreateRouteMappingRequest
    extends org.cloudfoundry.client.v2.routemappings._CreateRouteMappingRequest {
  private final String applicationId;
  private final @Nullable Integer applicationPort;
  private final String routeId;

  private CreateRouteMappingRequest(CreateRouteMappingRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.applicationPort = builder.applicationPort;
    this.routeId = builder.routeId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The application port on which the application should listen, and to which requests for the mapped route will be routed.
   */
  @Override
  public @Nullable Integer getApplicationPort() {
    return applicationPort;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * This instance is equal to all instances of {@code CreateRouteMappingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateRouteMappingRequest
        && equalTo((CreateRouteMappingRequest) another);
  }

  private boolean equalTo(CreateRouteMappingRequest another) {
    return applicationId.equals(another.applicationId)
        && Objects.equals(applicationPort, another.applicationPort)
        && routeId.equals(another.routeId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code applicationPort}, {@code routeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    h = h * 17 + Objects.hashCode(applicationPort);
    h = h * 17 + routeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateRouteMappingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateRouteMappingRequest{"
        + "applicationId=" + applicationId
        + ", applicationPort=" + applicationPort
        + ", routeId=" + routeId
        + "}";
  }

  /**
   * Creates a builder for {@link CreateRouteMappingRequest CreateRouteMappingRequest}.
   * @return A new CreateRouteMappingRequest builder
   */
  public static CreateRouteMappingRequest.Builder builder() {
    return new CreateRouteMappingRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateRouteMappingRequest CreateRouteMappingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_ROUTE_ID = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private Integer applicationPort;
    private String routeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateRouteMappingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateRouteMappingRequest instance) {
      return from((_CreateRouteMappingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateRouteMappingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateRouteMappingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      Integer applicationPortValue = instance.getApplicationPort();
      if (applicationPortValue != null) {
        applicationPort(applicationPortValue);
      }
      routeId(instance.getRouteId());
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateRouteMappingRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateRouteMappingRequest#getApplicationPort() applicationPort} attribute.
     * @param applicationPort The value for applicationPort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationPort(@Nullable Integer applicationPort) {
      this.applicationPort = applicationPort;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateRouteMappingRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Builds a new {@link CreateRouteMappingRequest CreateRouteMappingRequest}.
     * @return An immutable instance of CreateRouteMappingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateRouteMappingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateRouteMappingRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build CreateRouteMappingRequest, some of required attributes are not set " + attributes;
    }
  }
}
