package org.cloudfoundry.client.v2.servicebrokers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _CreateServiceBrokerRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CreateServiceBrokerRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CreateServiceBrokerRequest"})
public final class CreateServiceBrokerRequest
    extends org.cloudfoundry.client.v2.servicebrokers._CreateServiceBrokerRequest {
  private final String authenticationPassword;
  private final String authenticationUsername;
  private final String brokerUrl;
  private final String name;
  private final @Nullable String spaceId;

  private CreateServiceBrokerRequest(CreateServiceBrokerRequest.Builder builder) {
    this.authenticationPassword = builder.authenticationPassword;
    this.authenticationUsername = builder.authenticationUsername;
    this.brokerUrl = builder.brokerUrl;
    this.name = builder.name;
    this.spaceId = builder.spaceId;
  }

  /**
   * The password with which to authenticate against the service broker.
   */
  @Override
  public String getAuthenticationPassword() {
    return authenticationPassword;
  }

  /**
   * The username with which to authenticate against the service broker.
   */
  @Override
  public String getAuthenticationUsername() {
    return authenticationUsername;
  }

  /**
   * The url of the service broker.
   */
  @Override
  public String getBrokerUrl() {
    return brokerUrl;
  }

  /**
   * The name of the service broker.
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * (experimental) Guid of a space the broker is scoped to. Space developers are able to create service brokers scoped to a space.
   */
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceBrokerRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceBrokerRequest
        && equalTo((CreateServiceBrokerRequest) another);
  }

  private boolean equalTo(CreateServiceBrokerRequest another) {
    return authenticationPassword.equals(another.authenticationPassword)
        && authenticationUsername.equals(another.authenticationUsername)
        && brokerUrl.equals(another.brokerUrl)
        && name.equals(another.name)
        && Objects.equals(spaceId, another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code authenticationPassword}, {@code authenticationUsername}, {@code brokerUrl}, {@code name}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + authenticationPassword.hashCode();
    h = h * 17 + authenticationUsername.hashCode();
    h = h * 17 + brokerUrl.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(spaceId);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceBrokerRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServiceBrokerRequest{"
        + "authenticationPassword=" + authenticationPassword
        + ", authenticationUsername=" + authenticationUsername
        + ", brokerUrl=" + brokerUrl
        + ", name=" + name
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link CreateServiceBrokerRequest CreateServiceBrokerRequest}.
   * @return A new CreateServiceBrokerRequest builder
   */
  public static CreateServiceBrokerRequest.Builder builder() {
    return new CreateServiceBrokerRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceBrokerRequest CreateServiceBrokerRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_AUTHENTICATION_PASSWORD = 0x1L;
    private static final long INIT_BIT_AUTHENTICATION_USERNAME = 0x2L;
    private static final long INIT_BIT_BROKER_URL = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private long initBits = 0xfL;

    private String authenticationPassword;
    private String authenticationUsername;
    private String brokerUrl;
    private String name;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceBrokerRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceBrokerRequest instance) {
      return from((_CreateServiceBrokerRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServiceBrokerRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceBrokerRequest instance) {
      Objects.requireNonNull(instance, "instance");
      authenticationPassword(instance.getAuthenticationPassword());
      authenticationUsername(instance.getAuthenticationUsername());
      brokerUrl(instance.getBrokerUrl());
      name(instance.getName());
      String spaceIdValue = instance.getSpaceId();
      if (spaceIdValue != null) {
        spaceId(spaceIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBrokerRequest#getAuthenticationPassword() authenticationPassword} attribute.
     * @param authenticationPassword The value for authenticationPassword 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authenticationPassword(String authenticationPassword) {
      this.authenticationPassword = Objects.requireNonNull(authenticationPassword, "authenticationPassword");
      initBits &= ~INIT_BIT_AUTHENTICATION_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBrokerRequest#getAuthenticationUsername() authenticationUsername} attribute.
     * @param authenticationUsername The value for authenticationUsername 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authenticationUsername(String authenticationUsername) {
      this.authenticationUsername = Objects.requireNonNull(authenticationUsername, "authenticationUsername");
      initBits &= ~INIT_BIT_AUTHENTICATION_USERNAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBrokerRequest#getBrokerUrl() brokerUrl} attribute.
     * @param brokerUrl The value for brokerUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder brokerUrl(String brokerUrl) {
      this.brokerUrl = Objects.requireNonNull(brokerUrl, "brokerUrl");
      initBits &= ~INIT_BIT_BROKER_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBrokerRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBrokerRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Builds a new {@link CreateServiceBrokerRequest CreateServiceBrokerRequest}.
     * @return An immutable instance of CreateServiceBrokerRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceBrokerRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateServiceBrokerRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_AUTHENTICATION_PASSWORD) != 0) attributes.add("authenticationPassword");
      if ((initBits & INIT_BIT_AUTHENTICATION_USERNAME) != 0) attributes.add("authenticationUsername");
      if ((initBits & INIT_BIT_BROKER_URL) != 0) attributes.add("brokerUrl");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateServiceBrokerRequest, some of required attributes are not set " + attributes;
    }
  }
}
