package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _GetServiceInstancePermissionsRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetServiceInstancePermissionsRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetServiceInstancePermissionsRequest"})
public final class GetServiceInstancePermissionsRequest
    extends org.cloudfoundry.client.v2.serviceinstances._GetServiceInstancePermissionsRequest {
  private final String serviceInstanceId;

  private GetServiceInstancePermissionsRequest(GetServiceInstancePermissionsRequest.Builder builder) {
    this.serviceInstanceId = builder.serviceInstanceId;
  }

  /**
   * The service instance id
   */
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceInstancePermissionsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceInstancePermissionsRequest
        && equalTo((GetServiceInstancePermissionsRequest) another);
  }

  private boolean equalTo(GetServiceInstancePermissionsRequest another) {
    return serviceInstanceId.equals(another.serviceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + serviceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceInstancePermissionsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceInstancePermissionsRequest{"
        + "serviceInstanceId=" + serviceInstanceId
        + "}";
  }

  /**
   * Creates a builder for {@link GetServiceInstancePermissionsRequest GetServiceInstancePermissionsRequest}.
   * @return A new GetServiceInstancePermissionsRequest builder
   */
  public static GetServiceInstancePermissionsRequest.Builder builder() {
    return new GetServiceInstancePermissionsRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceInstancePermissionsRequest GetServiceInstancePermissionsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceInstancePermissionsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceInstancePermissionsRequest instance) {
      return from((_GetServiceInstancePermissionsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetServiceInstancePermissionsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServiceInstancePermissionsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceInstanceId(instance.getServiceInstanceId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetServiceInstancePermissionsRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link GetServiceInstancePermissionsRequest GetServiceInstancePermissionsRequest}.
     * @return An immutable instance of GetServiceInstancePermissionsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceInstancePermissionsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServiceInstancePermissionsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build GetServiceInstancePermissionsRequest, some of required attributes are not set " + attributes;
    }
  }
}
